package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmeetings.model.primitives.GuidString
import scala.jdk.CollectionConverters._
final case class BatchCreateAttendeeRequest(
    meetingId: GuidString,
    attendees: Iterable[
      zio.aws.chimesdkmeetings.model.CreateAttendeeRequestItem
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.BatchCreateAttendeeRequest = {
    import BatchCreateAttendeeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.BatchCreateAttendeeRequest
      .builder()
      .meetingId(GuidString.unwrap(meetingId): java.lang.String)
      .attendees(attendees.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmeetings.model.BatchCreateAttendeeRequest.ReadOnly =
    zio.aws.chimesdkmeetings.model.BatchCreateAttendeeRequest
      .wrap(buildAwsValue())
}
object BatchCreateAttendeeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.BatchCreateAttendeeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmeetings.model.BatchCreateAttendeeRequest =
      zio.aws.chimesdkmeetings.model.BatchCreateAttendeeRequest(
        meetingId,
        attendees.map { item =>
          item.asEditable
        }
      )
    def meetingId: GuidString
    def attendees: List[
      zio.aws.chimesdkmeetings.model.CreateAttendeeRequestItem.ReadOnly
    ]
    def getMeetingId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(meetingId)
    def getAttendees: ZIO[Any, Nothing, List[
      zio.aws.chimesdkmeetings.model.CreateAttendeeRequestItem.ReadOnly
    ]] = ZIO.succeed(attendees)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.BatchCreateAttendeeRequest
  ) extends zio.aws.chimesdkmeetings.model.BatchCreateAttendeeRequest.ReadOnly {
    override val meetingId: GuidString =
      zio.aws.chimesdkmeetings.model.primitives.GuidString(impl.meetingId())
    override val attendees: List[
      zio.aws.chimesdkmeetings.model.CreateAttendeeRequestItem.ReadOnly
    ] = impl
      .attendees()
      .asScala
      .map { item =>
        zio.aws.chimesdkmeetings.model.CreateAttendeeRequestItem.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.BatchCreateAttendeeRequest
  ): zio.aws.chimesdkmeetings.model.BatchCreateAttendeeRequest.ReadOnly =
    new Wrapper(impl)
}
