package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmeetings.model.primitives.{ExternalUserId, GuidString}
import scala.jdk.CollectionConverters._
final case class CreateAttendeeRequest(
    meetingId: GuidString,
    externalUserId: ExternalUserId,
    capabilities: Optional[
      zio.aws.chimesdkmeetings.model.AttendeeCapabilities
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeRequest = {
    import CreateAttendeeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeRequest
      .builder()
      .meetingId(GuidString.unwrap(meetingId): java.lang.String)
      .externalUserId(ExternalUserId.unwrap(externalUserId): java.lang.String)
      .optionallyWith(capabilities.map(value => value.buildAwsValue()))(
        _.capabilities
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmeetings.model.CreateAttendeeRequest.ReadOnly =
    zio.aws.chimesdkmeetings.model.CreateAttendeeRequest.wrap(buildAwsValue())
}
object CreateAttendeeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmeetings.model.CreateAttendeeRequest =
      zio.aws.chimesdkmeetings.model.CreateAttendeeRequest(
        meetingId,
        externalUserId,
        capabilities.map(value => value.asEditable)
      )
    def meetingId: GuidString
    def externalUserId: ExternalUserId
    def capabilities
        : Optional[zio.aws.chimesdkmeetings.model.AttendeeCapabilities.ReadOnly]
    def getMeetingId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(meetingId)
    def getExternalUserId: ZIO[Any, Nothing, ExternalUserId] =
      ZIO.succeed(externalUserId)
    def getCapabilities: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmeetings.model.AttendeeCapabilities.ReadOnly
    ] = AwsError.unwrapOptionField("capabilities", capabilities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeRequest
  ) extends zio.aws.chimesdkmeetings.model.CreateAttendeeRequest.ReadOnly {
    override val meetingId: GuidString =
      zio.aws.chimesdkmeetings.model.primitives.GuidString(impl.meetingId())
    override val externalUserId: ExternalUserId =
      zio.aws.chimesdkmeetings.model.primitives
        .ExternalUserId(impl.externalUserId())
    override val capabilities: Optional[
      zio.aws.chimesdkmeetings.model.AttendeeCapabilities.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.capabilities())
      .map(value =>
        zio.aws.chimesdkmeetings.model.AttendeeCapabilities.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeRequest
  ): zio.aws.chimesdkmeetings.model.CreateAttendeeRequest.ReadOnly =
    new Wrapper(impl)
}
