package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateMeetingResponse(
    meeting: Optional[zio.aws.chimesdkmeetings.model.Meeting] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.CreateMeetingResponse = {
    import CreateMeetingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.CreateMeetingResponse
      .builder()
      .optionallyWith(meeting.map(value => value.buildAwsValue()))(_.meeting)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmeetings.model.CreateMeetingResponse.ReadOnly =
    zio.aws.chimesdkmeetings.model.CreateMeetingResponse.wrap(buildAwsValue())
}
object CreateMeetingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.CreateMeetingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmeetings.model.CreateMeetingResponse =
      zio.aws.chimesdkmeetings.model
        .CreateMeetingResponse(meeting.map(value => value.asEditable))
    def meeting: Optional[zio.aws.chimesdkmeetings.model.Meeting.ReadOnly]
    def getMeeting
        : ZIO[Any, AwsError, zio.aws.chimesdkmeetings.model.Meeting.ReadOnly] =
      AwsError.unwrapOptionField("meeting", meeting)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.CreateMeetingResponse
  ) extends zio.aws.chimesdkmeetings.model.CreateMeetingResponse.ReadOnly {
    override val meeting
        : Optional[zio.aws.chimesdkmeetings.model.Meeting.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.meeting())
        .map(value => zio.aws.chimesdkmeetings.model.Meeting.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.CreateMeetingResponse
  ): zio.aws.chimesdkmeetings.model.CreateMeetingResponse.ReadOnly =
    new Wrapper(impl)
}
