package zio.aws.chimesdkmeetings.model
import scala.jdk.CollectionConverters._
sealed trait MediaCapabilities {
  def unwrap
      : software.amazon.awssdk.services.chimesdkmeetings.model.MediaCapabilities
}
object MediaCapabilities {
  def wrap(
      value: software.amazon.awssdk.services.chimesdkmeetings.model.MediaCapabilities
  ): zio.aws.chimesdkmeetings.model.MediaCapabilities = value match {
    case software.amazon.awssdk.services.chimesdkmeetings.model.MediaCapabilities.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chimesdkmeetings.model.MediaCapabilities.SEND_RECEIVE =>
      val r = SendReceive
      r
    case software.amazon.awssdk.services.chimesdkmeetings.model.MediaCapabilities.SEND =>
      val r = Send
      r
    case software.amazon.awssdk.services.chimesdkmeetings.model.MediaCapabilities.RECEIVE =>
      val r = Receive
      r
    case software.amazon.awssdk.services.chimesdkmeetings.model.MediaCapabilities.NONE =>
      val r = None
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chimesdkmeetings.model.MediaCapabilities {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmeetings.model.MediaCapabilities =
      software.amazon.awssdk.services.chimesdkmeetings.model.MediaCapabilities.UNKNOWN_TO_SDK_VERSION
  }
  case object SendReceive
      extends zio.aws.chimesdkmeetings.model.MediaCapabilities {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmeetings.model.MediaCapabilities =
      software.amazon.awssdk.services.chimesdkmeetings.model.MediaCapabilities.SEND_RECEIVE
  }
  case object Send extends zio.aws.chimesdkmeetings.model.MediaCapabilities {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmeetings.model.MediaCapabilities =
      software.amazon.awssdk.services.chimesdkmeetings.model.MediaCapabilities.SEND
  }
  case object Receive extends zio.aws.chimesdkmeetings.model.MediaCapabilities {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmeetings.model.MediaCapabilities =
      software.amazon.awssdk.services.chimesdkmeetings.model.MediaCapabilities.RECEIVE
  }
  case object None extends zio.aws.chimesdkmeetings.model.MediaCapabilities {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmeetings.model.MediaCapabilities =
      software.amazon.awssdk.services.chimesdkmeetings.model.MediaCapabilities.NONE
  }
}
