package zio.aws.chimesdkmeetings.model
import scala.jdk.CollectionConverters._
sealed trait TranscribeRegion {
  def unwrap
      : software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion
}
object TranscribeRegion {
  def wrap(
      value: software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion
  ): zio.aws.chimesdkmeetings.model.TranscribeRegion = value match {
    case software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion.US_EAST_2 =>
      val r = `us-east-2`
      r
    case software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion.US_EAST_1 =>
      val r = `us-east-1`
      r
    case software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion.US_WEST_2 =>
      val r = `us-west-2`
      r
    case software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion.AP_NORTHEAST_2 =>
      val r = `ap-northeast-2`
      r
    case software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion.AP_SOUTHEAST_2 =>
      val r = `ap-southeast-2`
      r
    case software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion.AP_NORTHEAST_1 =>
      val r = `ap-northeast-1`
      r
    case software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion.CA_CENTRAL_1 =>
      val r = `ca-central-1`
      r
    case software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion.EU_CENTRAL_1 =>
      val r = `eu-central-1`
      r
    case software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion.EU_WEST_1 =>
      val r = `eu-west-1`
      r
    case software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion.EU_WEST_2 =>
      val r = `eu-west-2`
      r
    case software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion.SA_EAST_1 =>
      val r = `sa-east-1`
      r
    case software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion.AUTO =>
      val r = auto
      r
    case software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion.US_GOV_WEST_1 =>
      val r = `us-gov-west-1`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chimesdkmeetings.model.TranscribeRegion {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion =
      software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion.UNKNOWN_TO_SDK_VERSION
  }
  case object `us-east-2`
      extends zio.aws.chimesdkmeetings.model.TranscribeRegion {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion =
      software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion.US_EAST_2
  }
  case object `us-east-1`
      extends zio.aws.chimesdkmeetings.model.TranscribeRegion {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion =
      software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion.US_EAST_1
  }
  case object `us-west-2`
      extends zio.aws.chimesdkmeetings.model.TranscribeRegion {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion =
      software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion.US_WEST_2
  }
  case object `ap-northeast-2`
      extends zio.aws.chimesdkmeetings.model.TranscribeRegion {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion =
      software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion.AP_NORTHEAST_2
  }
  case object `ap-southeast-2`
      extends zio.aws.chimesdkmeetings.model.TranscribeRegion {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion =
      software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion.AP_SOUTHEAST_2
  }
  case object `ap-northeast-1`
      extends zio.aws.chimesdkmeetings.model.TranscribeRegion {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion =
      software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion.AP_NORTHEAST_1
  }
  case object `ca-central-1`
      extends zio.aws.chimesdkmeetings.model.TranscribeRegion {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion =
      software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion.CA_CENTRAL_1
  }
  case object `eu-central-1`
      extends zio.aws.chimesdkmeetings.model.TranscribeRegion {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion =
      software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion.EU_CENTRAL_1
  }
  case object `eu-west-1`
      extends zio.aws.chimesdkmeetings.model.TranscribeRegion {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion =
      software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion.EU_WEST_1
  }
  case object `eu-west-2`
      extends zio.aws.chimesdkmeetings.model.TranscribeRegion {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion =
      software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion.EU_WEST_2
  }
  case object `sa-east-1`
      extends zio.aws.chimesdkmeetings.model.TranscribeRegion {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion =
      software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion.SA_EAST_1
  }
  case object auto extends zio.aws.chimesdkmeetings.model.TranscribeRegion {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion =
      software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion.AUTO
  }
  case object `us-gov-west-1`
      extends zio.aws.chimesdkmeetings.model.TranscribeRegion {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion =
      software.amazon.awssdk.services.chimesdkmeetings.model.TranscribeRegion.US_GOV_WEST_1
  }
}
