package zio.aws.chimesdkmeetings.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmeetings.model.primitives.GuidString
import scala.jdk.CollectionConverters._
final case class UpdateAttendeeCapabilitiesRequest(
    meetingId: GuidString,
    attendeeId: GuidString,
    capabilities: zio.aws.chimesdkmeetings.model.AttendeeCapabilities
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmeetings.model.UpdateAttendeeCapabilitiesRequest = {
    import UpdateAttendeeCapabilitiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmeetings.model.UpdateAttendeeCapabilitiesRequest
      .builder()
      .meetingId(GuidString.unwrap(meetingId): java.lang.String)
      .attendeeId(GuidString.unwrap(attendeeId): java.lang.String)
      .capabilities(capabilities.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmeetings.model.UpdateAttendeeCapabilitiesRequest.ReadOnly =
    zio.aws.chimesdkmeetings.model.UpdateAttendeeCapabilitiesRequest
      .wrap(buildAwsValue())
}
object UpdateAttendeeCapabilitiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmeetings.model.UpdateAttendeeCapabilitiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmeetings.model.UpdateAttendeeCapabilitiesRequest =
      zio.aws.chimesdkmeetings.model.UpdateAttendeeCapabilitiesRequest(
        meetingId,
        attendeeId,
        capabilities.asEditable
      )
    def meetingId: GuidString
    def attendeeId: GuidString
    def capabilities
        : zio.aws.chimesdkmeetings.model.AttendeeCapabilities.ReadOnly
    def getMeetingId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(meetingId)
    def getAttendeeId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(attendeeId)
    def getCapabilities: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmeetings.model.AttendeeCapabilities.ReadOnly
    ] = ZIO.succeed(capabilities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.UpdateAttendeeCapabilitiesRequest
  ) extends zio.aws.chimesdkmeetings.model.UpdateAttendeeCapabilitiesRequest.ReadOnly {
    override val meetingId: GuidString =
      zio.aws.chimesdkmeetings.model.primitives.GuidString(impl.meetingId())
    override val attendeeId: GuidString =
      zio.aws.chimesdkmeetings.model.primitives.GuidString(impl.attendeeId())
    override val capabilities
        : zio.aws.chimesdkmeetings.model.AttendeeCapabilities.ReadOnly =
      zio.aws.chimesdkmeetings.model.AttendeeCapabilities
        .wrap(impl.capabilities())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmeetings.model.UpdateAttendeeCapabilitiesRequest
  ): zio.aws.chimesdkmeetings.model.UpdateAttendeeCapabilitiesRequest.ReadOnly =
    new Wrapper(impl)
}
