package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait AccountGateStatus {
  def unwrap
      : software.amazon.awssdk.services.cloudformation.model.AccountGateStatus
}
object AccountGateStatus {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.AccountGateStatus
  ): zio.aws.cloudformation.model.AccountGateStatus = value match {
    case software.amazon.awssdk.services.cloudformation.model.AccountGateStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.AccountGateStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.cloudformation.model.AccountGateStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.cloudformation.model.AccountGateStatus.SKIPPED =>
      val r = SKIPPED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.AccountGateStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.AccountGateStatus =
      software.amazon.awssdk.services.cloudformation.model.AccountGateStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object SUCCEEDED extends zio.aws.cloudformation.model.AccountGateStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.AccountGateStatus =
      software.amazon.awssdk.services.cloudformation.model.AccountGateStatus.SUCCEEDED
  }
  case object FAILED extends zio.aws.cloudformation.model.AccountGateStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.AccountGateStatus =
      software.amazon.awssdk.services.cloudformation.model.AccountGateStatus.FAILED
  }
  case object SKIPPED extends zio.aws.cloudformation.model.AccountGateStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.AccountGateStatus =
      software.amazon.awssdk.services.cloudformation.model.AccountGateStatus.SKIPPED
  }
}
