package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  PublisherId,
  RoleArn,
  ThirdPartyTypeArn,
  AutoUpdate,
  TypeName,
  MajorVersion
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ActivateTypeRequest(
    `type`: Optional[zio.aws.cloudformation.model.ThirdPartyType] =
      Optional.Absent,
    publicTypeArn: Optional[ThirdPartyTypeArn] = Optional.Absent,
    publisherId: Optional[PublisherId] = Optional.Absent,
    typeName: Optional[TypeName] = Optional.Absent,
    typeNameAlias: Optional[TypeName] = Optional.Absent,
    autoUpdate: Optional[AutoUpdate] = Optional.Absent,
    loggingConfig: Optional[zio.aws.cloudformation.model.LoggingConfig] =
      Optional.Absent,
    executionRoleArn: Optional[RoleArn] = Optional.Absent,
    versionBump: Optional[zio.aws.cloudformation.model.VersionBump] =
      Optional.Absent,
    majorVersion: Optional[MajorVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ActivateTypeRequest = {
    import ActivateTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ActivateTypeRequest
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        publicTypeArn.map(value =>
          ThirdPartyTypeArn.unwrap(value): java.lang.String
        )
      )(_.publicTypeArn)
      .optionallyWith(
        publisherId.map(value => PublisherId.unwrap(value): java.lang.String)
      )(_.publisherId)
      .optionallyWith(
        typeName.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.typeName)
      .optionallyWith(
        typeNameAlias.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.typeNameAlias)
      .optionallyWith(
        autoUpdate.map(value => AutoUpdate.unwrap(value): java.lang.Boolean)
      )(_.autoUpdate)
      .optionallyWith(loggingConfig.map(value => value.buildAwsValue()))(
        _.loggingConfig
      )
      .optionallyWith(
        executionRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.executionRoleArn)
      .optionallyWith(versionBump.map(value => value.unwrap))(_.versionBump)
      .optionallyWith(
        majorVersion.map(value => MajorVersion.unwrap(value): java.lang.Long)
      )(_.majorVersion)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.ActivateTypeRequest.ReadOnly =
    zio.aws.cloudformation.model.ActivateTypeRequest.wrap(buildAwsValue())
}
object ActivateTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ActivateTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ActivateTypeRequest =
      zio.aws.cloudformation.model.ActivateTypeRequest(
        `type`.map(value => value),
        publicTypeArn.map(value => value),
        publisherId.map(value => value),
        typeName.map(value => value),
        typeNameAlias.map(value => value),
        autoUpdate.map(value => value),
        loggingConfig.map(value => value.asEditable),
        executionRoleArn.map(value => value),
        versionBump.map(value => value),
        majorVersion.map(value => value)
      )
    def `type`: Optional[zio.aws.cloudformation.model.ThirdPartyType]
    def publicTypeArn: Optional[ThirdPartyTypeArn]
    def publisherId: Optional[PublisherId]
    def typeName: Optional[TypeName]
    def typeNameAlias: Optional[TypeName]
    def autoUpdate: Optional[AutoUpdate]
    def loggingConfig
        : Optional[zio.aws.cloudformation.model.LoggingConfig.ReadOnly]
    def executionRoleArn: Optional[RoleArn]
    def versionBump: Optional[zio.aws.cloudformation.model.VersionBump]
    def majorVersion: Optional[MajorVersion]
    def getType
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.ThirdPartyType] =
      AwsError.unwrapOptionField("type", `type`)
    def getPublicTypeArn: ZIO[Any, AwsError, ThirdPartyTypeArn] =
      AwsError.unwrapOptionField("publicTypeArn", publicTypeArn)
    def getPublisherId: ZIO[Any, AwsError, PublisherId] =
      AwsError.unwrapOptionField("publisherId", publisherId)
    def getTypeName: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getTypeNameAlias: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("typeNameAlias", typeNameAlias)
    def getAutoUpdate: ZIO[Any, AwsError, AutoUpdate] =
      AwsError.unwrapOptionField("autoUpdate", autoUpdate)
    def getLoggingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.LoggingConfig.ReadOnly
    ] = AwsError.unwrapOptionField("loggingConfig", loggingConfig)
    def getExecutionRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("executionRoleArn", executionRoleArn)
    def getVersionBump
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.VersionBump] =
      AwsError.unwrapOptionField("versionBump", versionBump)
    def getMajorVersion: ZIO[Any, AwsError, MajorVersion] =
      AwsError.unwrapOptionField("majorVersion", majorVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ActivateTypeRequest
  ) extends zio.aws.cloudformation.model.ActivateTypeRequest.ReadOnly {
    override val `type`: Optional[zio.aws.cloudformation.model.ThirdPartyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.cloudformation.model.ThirdPartyType.wrap(value))
    override val publicTypeArn: Optional[ThirdPartyTypeArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publicTypeArn())
        .map(value =>
          zio.aws.cloudformation.model.primitives.ThirdPartyTypeArn(value)
        )
    override val publisherId: Optional[PublisherId] = zio.aws.core.internal
      .optionalFromNullable(impl.publisherId())
      .map(value => zio.aws.cloudformation.model.primitives.PublisherId(value))
    override val typeName: Optional[TypeName] = zio.aws.core.internal
      .optionalFromNullable(impl.typeName())
      .map(value => zio.aws.cloudformation.model.primitives.TypeName(value))
    override val typeNameAlias: Optional[TypeName] = zio.aws.core.internal
      .optionalFromNullable(impl.typeNameAlias())
      .map(value => zio.aws.cloudformation.model.primitives.TypeName(value))
    override val autoUpdate: Optional[AutoUpdate] = zio.aws.core.internal
      .optionalFromNullable(impl.autoUpdate())
      .map(value => zio.aws.cloudformation.model.primitives.AutoUpdate(value))
    override val loggingConfig
        : Optional[zio.aws.cloudformation.model.LoggingConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loggingConfig())
        .map(value => zio.aws.cloudformation.model.LoggingConfig.wrap(value))
    override val executionRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.executionRoleArn())
      .map(value => zio.aws.cloudformation.model.primitives.RoleArn(value))
    override val versionBump
        : Optional[zio.aws.cloudformation.model.VersionBump] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionBump())
        .map(value => zio.aws.cloudformation.model.VersionBump.wrap(value))
    override val majorVersion: Optional[MajorVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.majorVersion())
      .map(value => zio.aws.cloudformation.model.primitives.MajorVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ActivateTypeRequest
  ): zio.aws.cloudformation.model.ActivateTypeRequest.ReadOnly = new Wrapper(
    impl
  )
}
