package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  RetainStacksOnAccountRemovalNullable,
  AutoDeploymentNullable
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AutoDeployment(
    enabled: Optional[AutoDeploymentNullable] = Optional.Absent,
    retainStacksOnAccountRemoval: Optional[
      RetainStacksOnAccountRemovalNullable
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.AutoDeployment = {
    import AutoDeployment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.AutoDeployment
      .builder()
      .optionallyWith(
        enabled.map(value =>
          AutoDeploymentNullable.unwrap(value): java.lang.Boolean
        )
      )(_.enabled)
      .optionallyWith(
        retainStacksOnAccountRemoval.map(value =>
          RetainStacksOnAccountRemovalNullable.unwrap(value): java.lang.Boolean
        )
      )(_.retainStacksOnAccountRemoval)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.AutoDeployment.ReadOnly =
    zio.aws.cloudformation.model.AutoDeployment.wrap(buildAwsValue())
}
object AutoDeployment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.AutoDeployment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.AutoDeployment =
      zio.aws.cloudformation.model.AutoDeployment(
        enabled.map(value => value),
        retainStacksOnAccountRemoval.map(value => value)
      )
    def enabled: Optional[AutoDeploymentNullable]
    def retainStacksOnAccountRemoval
        : Optional[RetainStacksOnAccountRemovalNullable]
    def getEnabled: ZIO[Any, AwsError, AutoDeploymentNullable] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getRetainStacksOnAccountRemoval
        : ZIO[Any, AwsError, RetainStacksOnAccountRemovalNullable] =
      AwsError.unwrapOptionField(
        "retainStacksOnAccountRemoval",
        retainStacksOnAccountRemoval
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.AutoDeployment
  ) extends zio.aws.cloudformation.model.AutoDeployment.ReadOnly {
    override val enabled: Optional[AutoDeploymentNullable] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enabled())
        .map(value =>
          zio.aws.cloudformation.model.primitives.AutoDeploymentNullable(value)
        )
    override val retainStacksOnAccountRemoval
        : Optional[RetainStacksOnAccountRemovalNullable] = zio.aws.core.internal
      .optionalFromNullable(impl.retainStacksOnAccountRemoval())
      .map(value =>
        zio.aws.cloudformation.model.primitives
          .RetainStacksOnAccountRemovalNullable(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.AutoDeployment
  ): zio.aws.cloudformation.model.AutoDeployment.ReadOnly = new Wrapper(impl)
}
