package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{ErrorMessage, ErrorCode}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchDescribeTypeConfigurationsError(
    errorCode: Optional[ErrorCode] = Optional.Absent,
    errorMessage: Optional[ErrorMessage] = Optional.Absent,
    typeConfigurationIdentifier: Optional[
      zio.aws.cloudformation.model.TypeConfigurationIdentifier
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsError = {
    import BatchDescribeTypeConfigurationsError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsError
      .builder()
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .optionallyWith(
        typeConfigurationIdentifier.map(value => value.buildAwsValue())
      )(_.typeConfigurationIdentifier)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsError.ReadOnly =
    zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsError
      .wrap(buildAwsValue())
}
object BatchDescribeTypeConfigurationsError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsError =
      zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsError(
        errorCode.map(value => value),
        errorMessage.map(value => value),
        typeConfigurationIdentifier.map(value => value.asEditable)
      )
    def errorCode: Optional[ErrorCode]
    def errorMessage: Optional[ErrorMessage]
    def typeConfigurationIdentifier: Optional[
      zio.aws.cloudformation.model.TypeConfigurationIdentifier.ReadOnly
    ]
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getTypeConfigurationIdentifier: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.TypeConfigurationIdentifier.ReadOnly
    ] = AwsError.unwrapOptionField(
      "typeConfigurationIdentifier",
      typeConfigurationIdentifier
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsError
  ) extends zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsError.ReadOnly {
    override val errorCode: Optional[ErrorCode] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => zio.aws.cloudformation.model.primitives.ErrorCode(value))
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.cloudformation.model.primitives.ErrorMessage(value))
    override val typeConfigurationIdentifier: Optional[
      zio.aws.cloudformation.model.TypeConfigurationIdentifier.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.typeConfigurationIdentifier())
      .map(value =>
        zio.aws.cloudformation.model.TypeConfigurationIdentifier.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsError
  ): zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsError.ReadOnly =
    new Wrapper(impl)
}
