package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  ClientRequestToken,
  RoleARN,
  LogicalResourceId,
  StackName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteStackRequest(
    stackName: StackName,
    retainResources: Optional[Iterable[LogicalResourceId]] = Optional.Absent,
    roleARN: Optional[RoleARN] = Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DeleteStackRequest = {
    import DeleteStackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DeleteStackRequest
      .builder()
      .stackName(StackName.unwrap(stackName): java.lang.String)
      .optionallyWith(
        retainResources.map(value =>
          value.map { item =>
            LogicalResourceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.retainResources)
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.DeleteStackRequest.ReadOnly =
    zio.aws.cloudformation.model.DeleteStackRequest.wrap(buildAwsValue())
}
object DeleteStackRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DeleteStackRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DeleteStackRequest =
      zio.aws.cloudformation.model.DeleteStackRequest(
        stackName,
        retainResources.map(value => value),
        roleARN.map(value => value),
        clientRequestToken.map(value => value)
      )
    def stackName: StackName
    def retainResources: Optional[List[LogicalResourceId]]
    def roleARN: Optional[RoleARN]
    def clientRequestToken: Optional[ClientRequestToken]
    def getStackName: ZIO[Any, Nothing, StackName] = ZIO.succeed(stackName)
    def getRetainResources: ZIO[Any, AwsError, List[LogicalResourceId]] =
      AwsError.unwrapOptionField("retainResources", retainResources)
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DeleteStackRequest
  ) extends zio.aws.cloudformation.model.DeleteStackRequest.ReadOnly {
    override val stackName: StackName =
      zio.aws.cloudformation.model.primitives.StackName(impl.stackName())
    override val retainResources: Optional[List[LogicalResourceId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retainResources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.primitives.LogicalResourceId(item)
          }.toList
        )
    override val roleARN: Optional[RoleARN] = zio.aws.core.internal
      .optionalFromNullable(impl.roleARN())
      .map(value => zio.aws.cloudformation.model.primitives.RoleARN(value))
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.cloudformation.model.primitives.ClientRequestToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DeleteStackRequest
  ): zio.aws.cloudformation.model.DeleteStackRequest.ReadOnly = new Wrapper(
    impl
  )
}
