package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.StackSetName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteStackSetRequest(
    stackSetName: StackSetName,
    callAs: Optional[zio.aws.cloudformation.model.CallAs] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DeleteStackSetRequest = {
    import DeleteStackSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DeleteStackSetRequest
      .builder()
      .stackSetName(StackSetName.unwrap(stackSetName): java.lang.String)
      .optionallyWith(callAs.map(value => value.unwrap))(_.callAs)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.DeleteStackSetRequest.ReadOnly =
    zio.aws.cloudformation.model.DeleteStackSetRequest.wrap(buildAwsValue())
}
object DeleteStackSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DeleteStackSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DeleteStackSetRequest =
      zio.aws.cloudformation.model
        .DeleteStackSetRequest(stackSetName, callAs.map(value => value))
    def stackSetName: StackSetName
    def callAs: Optional[zio.aws.cloudformation.model.CallAs]
    def getStackSetName: ZIO[Any, Nothing, StackSetName] =
      ZIO.succeed(stackSetName)
    def getCallAs: ZIO[Any, AwsError, zio.aws.cloudformation.model.CallAs] =
      AwsError.unwrapOptionField("callAs", callAs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DeleteStackSetRequest
  ) extends zio.aws.cloudformation.model.DeleteStackSetRequest.ReadOnly {
    override val stackSetName: StackSetName =
      zio.aws.cloudformation.model.primitives.StackSetName(impl.stackSetName())
    override val callAs: Optional[zio.aws.cloudformation.model.CallAs] =
      zio.aws.core.internal
        .optionalFromNullable(impl.callAs())
        .map(value => zio.aws.cloudformation.model.CallAs.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DeleteStackSetRequest
  ): zio.aws.cloudformation.model.DeleteStackSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
