package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  TypeVersionId,
  TypeName,
  PrivateTypeArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeregisterTypeRequest(
    arn: Optional[PrivateTypeArn] = Optional.Absent,
    `type`: Optional[zio.aws.cloudformation.model.RegistryType] =
      Optional.Absent,
    typeName: Optional[TypeName] = Optional.Absent,
    versionId: Optional[TypeVersionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DeregisterTypeRequest = {
    import DeregisterTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DeregisterTypeRequest
      .builder()
      .optionallyWith(
        arn.map(value => PrivateTypeArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        typeName.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.typeName)
      .optionallyWith(
        versionId.map(value => TypeVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.DeregisterTypeRequest.ReadOnly =
    zio.aws.cloudformation.model.DeregisterTypeRequest.wrap(buildAwsValue())
}
object DeregisterTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DeregisterTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DeregisterTypeRequest =
      zio.aws.cloudformation.model.DeregisterTypeRequest(
        arn.map(value => value),
        `type`.map(value => value),
        typeName.map(value => value),
        versionId.map(value => value)
      )
    def arn: Optional[PrivateTypeArn]
    def `type`: Optional[zio.aws.cloudformation.model.RegistryType]
    def typeName: Optional[TypeName]
    def versionId: Optional[TypeVersionId]
    def getArn: ZIO[Any, AwsError, PrivateTypeArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getType: ZIO[Any, AwsError, zio.aws.cloudformation.model.RegistryType] =
      AwsError.unwrapOptionField("type", `type`)
    def getTypeName: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getVersionId: ZIO[Any, AwsError, TypeVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DeregisterTypeRequest
  ) extends zio.aws.cloudformation.model.DeregisterTypeRequest.ReadOnly {
    override val arn: Optional[PrivateTypeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.cloudformation.model.primitives.PrivateTypeArn(value)
      )
    override val `type`: Optional[zio.aws.cloudformation.model.RegistryType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.cloudformation.model.RegistryType.wrap(value))
    override val typeName: Optional[TypeName] = zio.aws.core.internal
      .optionalFromNullable(impl.typeName())
      .map(value => zio.aws.cloudformation.model.primitives.TypeName(value))
    override val versionId: Optional[TypeVersionId] = zio.aws.core.internal
      .optionalFromNullable(impl.versionId())
      .map(value =>
        zio.aws.cloudformation.model.primitives.TypeVersionId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DeregisterTypeRequest
  ): zio.aws.cloudformation.model.DeregisterTypeRequest.ReadOnly = new Wrapper(
    impl
  )
}
