package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{PublisherProfile, PublisherId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribePublisherResponse(
    publisherId: Optional[PublisherId] = Optional.Absent,
    publisherStatus: Optional[zio.aws.cloudformation.model.PublisherStatus] =
      Optional.Absent,
    identityProvider: Optional[zio.aws.cloudformation.model.IdentityProvider] =
      Optional.Absent,
    publisherProfile: Optional[PublisherProfile] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribePublisherResponse = {
    import DescribePublisherResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribePublisherResponse
      .builder()
      .optionallyWith(
        publisherId.map(value => PublisherId.unwrap(value): java.lang.String)
      )(_.publisherId)
      .optionallyWith(publisherStatus.map(value => value.unwrap))(
        _.publisherStatus
      )
      .optionallyWith(identityProvider.map(value => value.unwrap))(
        _.identityProvider
      )
      .optionallyWith(
        publisherProfile.map(value =>
          PublisherProfile.unwrap(value): java.lang.String
        )
      )(_.publisherProfile)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DescribePublisherResponse.ReadOnly =
    zio.aws.cloudformation.model.DescribePublisherResponse.wrap(buildAwsValue())
}
object DescribePublisherResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribePublisherResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DescribePublisherResponse =
      zio.aws.cloudformation.model.DescribePublisherResponse(
        publisherId.map(value => value),
        publisherStatus.map(value => value),
        identityProvider.map(value => value),
        publisherProfile.map(value => value)
      )
    def publisherId: Optional[PublisherId]
    def publisherStatus: Optional[zio.aws.cloudformation.model.PublisherStatus]
    def identityProvider
        : Optional[zio.aws.cloudformation.model.IdentityProvider]
    def publisherProfile: Optional[PublisherProfile]
    def getPublisherId: ZIO[Any, AwsError, PublisherId] =
      AwsError.unwrapOptionField("publisherId", publisherId)
    def getPublisherStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.PublisherStatus] =
      AwsError.unwrapOptionField("publisherStatus", publisherStatus)
    def getIdentityProvider
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.IdentityProvider] =
      AwsError.unwrapOptionField("identityProvider", identityProvider)
    def getPublisherProfile: ZIO[Any, AwsError, PublisherProfile] =
      AwsError.unwrapOptionField("publisherProfile", publisherProfile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribePublisherResponse
  ) extends zio.aws.cloudformation.model.DescribePublisherResponse.ReadOnly {
    override val publisherId: Optional[PublisherId] = zio.aws.core.internal
      .optionalFromNullable(impl.publisherId())
      .map(value => zio.aws.cloudformation.model.primitives.PublisherId(value))
    override val publisherStatus
        : Optional[zio.aws.cloudformation.model.PublisherStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publisherStatus())
        .map(value => zio.aws.cloudformation.model.PublisherStatus.wrap(value))
    override val identityProvider
        : Optional[zio.aws.cloudformation.model.IdentityProvider] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityProvider())
        .map(value => zio.aws.cloudformation.model.IdentityProvider.wrap(value))
    override val publisherProfile: Optional[PublisherProfile] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publisherProfile())
        .map(value =>
          zio.aws.cloudformation.model.primitives.PublisherProfile(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribePublisherResponse
  ): zio.aws.cloudformation.model.DescribePublisherResponse.ReadOnly =
    new Wrapper(impl)
}
