package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{NextToken, StackName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeStackEventsRequest(
    stackName: Optional[StackName] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest = {
    import DescribeStackEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest
      .builder()
      .optionallyWith(
        stackName.map(value => StackName.unwrap(value): java.lang.String)
      )(_.stackName)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DescribeStackEventsRequest.ReadOnly =
    zio.aws.cloudformation.model.DescribeStackEventsRequest
      .wrap(buildAwsValue())
}
object DescribeStackEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DescribeStackEventsRequest =
      zio.aws.cloudformation.model.DescribeStackEventsRequest(
        stackName.map(value => value),
        nextToken.map(value => value)
      )
    def stackName: Optional[StackName]
    def nextToken: Optional[NextToken]
    def getStackName: ZIO[Any, AwsError, StackName] =
      AwsError.unwrapOptionField("stackName", stackName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest
  ) extends zio.aws.cloudformation.model.DescribeStackEventsRequest.ReadOnly {
    override val stackName: Optional[StackName] = zio.aws.core.internal
      .optionalFromNullable(impl.stackName())
      .map(value => zio.aws.cloudformation.model.primitives.StackName(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest
  ): zio.aws.cloudformation.model.DescribeStackEventsRequest.ReadOnly =
    new Wrapper(impl)
}
