package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{LogicalResourceId, StackName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeStackResourceRequest(
    stackName: StackName,
    logicalResourceId: LogicalResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceRequest = {
    import DescribeStackResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceRequest
      .builder()
      .stackName(StackName.unwrap(stackName): java.lang.String)
      .logicalResourceId(
        LogicalResourceId.unwrap(logicalResourceId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DescribeStackResourceRequest.ReadOnly =
    zio.aws.cloudformation.model.DescribeStackResourceRequest
      .wrap(buildAwsValue())
}
object DescribeStackResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DescribeStackResourceRequest =
      zio.aws.cloudformation.model
        .DescribeStackResourceRequest(stackName, logicalResourceId)
    def stackName: StackName
    def logicalResourceId: LogicalResourceId
    def getStackName: ZIO[Any, Nothing, StackName] = ZIO.succeed(stackName)
    def getLogicalResourceId: ZIO[Any, Nothing, LogicalResourceId] =
      ZIO.succeed(logicalResourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceRequest
  ) extends zio.aws.cloudformation.model.DescribeStackResourceRequest.ReadOnly {
    override val stackName: StackName =
      zio.aws.cloudformation.model.primitives.StackName(impl.stackName())
    override val logicalResourceId: LogicalResourceId =
      zio.aws.cloudformation.model.primitives
        .LogicalResourceId(impl.logicalResourceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceRequest
  ): zio.aws.cloudformation.model.DescribeStackResourceRequest.ReadOnly =
    new Wrapper(impl)
}
