package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait EvaluationType {
  def unwrap
      : software.amazon.awssdk.services.cloudformation.model.EvaluationType
}
object EvaluationType {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.EvaluationType
  ): zio.aws.cloudformation.model.EvaluationType = value match {
    case software.amazon.awssdk.services.cloudformation.model.EvaluationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.EvaluationType.STATIC =>
      val r = Static
      r
    case software.amazon.awssdk.services.cloudformation.model.EvaluationType.DYNAMIC =>
      val r = Dynamic
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.EvaluationType {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.EvaluationType =
      software.amazon.awssdk.services.cloudformation.model.EvaluationType.UNKNOWN_TO_SDK_VERSION
  }
  case object Static extends zio.aws.cloudformation.model.EvaluationType {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.EvaluationType =
      software.amazon.awssdk.services.cloudformation.model.EvaluationType.STATIC
  }
  case object Dynamic extends zio.aws.cloudformation.model.EvaluationType {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.EvaluationType =
      software.amazon.awssdk.services.cloudformation.model.EvaluationType.DYNAMIC
  }
}
