package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.StackName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetStackPolicyRequest(stackName: StackName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.GetStackPolicyRequest = {
    import GetStackPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.GetStackPolicyRequest
      .builder()
      .stackName(StackName.unwrap(stackName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.GetStackPolicyRequest.ReadOnly =
    zio.aws.cloudformation.model.GetStackPolicyRequest.wrap(buildAwsValue())
}
object GetStackPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.GetStackPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.GetStackPolicyRequest =
      zio.aws.cloudformation.model.GetStackPolicyRequest(stackName)
    def stackName: StackName
    def getStackName: ZIO[Any, Nothing, StackName] = ZIO.succeed(stackName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.GetStackPolicyRequest
  ) extends zio.aws.cloudformation.model.GetStackPolicyRequest.ReadOnly {
    override val stackName: StackName =
      zio.aws.cloudformation.model.primitives.StackName(impl.stackName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.GetStackPolicyRequest
  ): zio.aws.cloudformation.model.GetStackPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
