package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait HookInvocationPoint {
  def unwrap
      : software.amazon.awssdk.services.cloudformation.model.HookInvocationPoint
}
object HookInvocationPoint {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.HookInvocationPoint
  ): zio.aws.cloudformation.model.HookInvocationPoint = value match {
    case software.amazon.awssdk.services.cloudformation.model.HookInvocationPoint.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.HookInvocationPoint.PRE_PROVISION =>
      val r = PRE_PROVISION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.HookInvocationPoint {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.HookInvocationPoint =
      software.amazon.awssdk.services.cloudformation.model.HookInvocationPoint.UNKNOWN_TO_SDK_VERSION
  }
  case object PRE_PROVISION
      extends zio.aws.cloudformation.model.HookInvocationPoint {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.HookInvocationPoint =
      software.amazon.awssdk.services.cloudformation.model.HookInvocationPoint.PRE_PROVISION
  }
}
