package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait HookTargetType {
  def unwrap
      : software.amazon.awssdk.services.cloudformation.model.HookTargetType
}
object HookTargetType {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.HookTargetType
  ): zio.aws.cloudformation.model.HookTargetType = value match {
    case software.amazon.awssdk.services.cloudformation.model.HookTargetType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.HookTargetType.RESOURCE =>
      val r = RESOURCE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.HookTargetType {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.HookTargetType =
      software.amazon.awssdk.services.cloudformation.model.HookTargetType.UNKNOWN_TO_SDK_VERSION
  }
  case object RESOURCE extends zio.aws.cloudformation.model.HookTargetType {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.HookTargetType =
      software.amazon.awssdk.services.cloudformation.model.HookTargetType.RESOURCE
  }
}
