package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.ClientRequestToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImportStacksToStackSetResponse(
    operationId: Optional[ClientRequestToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ImportStacksToStackSetResponse = {
    import ImportStacksToStackSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ImportStacksToStackSetResponse
      .builder()
      .optionallyWith(
        operationId.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.operationId)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.ImportStacksToStackSetResponse.ReadOnly =
    zio.aws.cloudformation.model.ImportStacksToStackSetResponse
      .wrap(buildAwsValue())
}
object ImportStacksToStackSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ImportStacksToStackSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudformation.model.ImportStacksToStackSetResponse =
      zio.aws.cloudformation.model
        .ImportStacksToStackSetResponse(operationId.map(value => value))
    def operationId: Optional[ClientRequestToken]
    def getOperationId: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("operationId", operationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ImportStacksToStackSetResponse
  ) extends zio.aws.cloudformation.model.ImportStacksToStackSetResponse.ReadOnly {
    override val operationId: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operationId())
        .map(value =>
          zio.aws.cloudformation.model.primitives.ClientRequestToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ImportStacksToStackSetResponse
  ): zio.aws.cloudformation.model.ImportStacksToStackSetResponse.ReadOnly =
    new Wrapper(impl)
}
