package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListExportsResponse(
    exports: Optional[Iterable[zio.aws.cloudformation.model.Export]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ListExportsResponse = {
    import ListExportsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ListExportsResponse
      .builder()
      .optionallyWith(
        exports.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.exports)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.ListExportsResponse.ReadOnly =
    zio.aws.cloudformation.model.ListExportsResponse.wrap(buildAwsValue())
}
object ListExportsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ListExportsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ListExportsResponse =
      zio.aws.cloudformation.model.ListExportsResponse(
        exports.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def exports: Optional[List[zio.aws.cloudformation.model.Export.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getExports: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.Export.ReadOnly
    ]] = AwsError.unwrapOptionField("exports", exports)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ListExportsResponse
  ) extends zio.aws.cloudformation.model.ListExportsResponse.ReadOnly {
    override val exports
        : Optional[List[zio.aws.cloudformation.model.Export.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exports())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Export.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ListExportsResponse
  ): zio.aws.cloudformation.model.ListExportsResponse.ReadOnly = new Wrapper(
    impl
  )
}
