package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{NextToken, StackName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListImportsResponse(
    imports: Optional[Iterable[StackName]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ListImportsResponse = {
    import ListImportsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ListImportsResponse
      .builder()
      .optionallyWith(
        imports.map(value =>
          value.map { item =>
            StackName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.imports)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.ListImportsResponse.ReadOnly =
    zio.aws.cloudformation.model.ListImportsResponse.wrap(buildAwsValue())
}
object ListImportsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ListImportsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ListImportsResponse =
      zio.aws.cloudformation.model.ListImportsResponse(
        imports.map(value => value),
        nextToken.map(value => value)
      )
    def imports: Optional[List[StackName]]
    def nextToken: Optional[NextToken]
    def getImports: ZIO[Any, AwsError, List[StackName]] =
      AwsError.unwrapOptionField("imports", imports)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ListImportsResponse
  ) extends zio.aws.cloudformation.model.ListImportsResponse.ReadOnly {
    override val imports: Optional[List[StackName]] = zio.aws.core.internal
      .optionalFromNullable(impl.imports())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.primitives.StackName(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ListImportsResponse
  ): zio.aws.cloudformation.model.ListImportsResponse.ReadOnly = new Wrapper(
    impl
  )
}
