package zio.aws.cloudformation.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudformation.model.primitives.{
  Account,
  NextToken,
  StackSetName,
  Region,
  MaxResults
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListStackInstancesRequest(
    stackSetName: StackSetName,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    filters: Optional[
      Iterable[zio.aws.cloudformation.model.StackInstanceFilter]
    ] = Optional.Absent,
    stackInstanceAccount: Optional[Account] = Optional.Absent,
    stackInstanceRegion: Optional[Region] = Optional.Absent,
    callAs: Optional[zio.aws.cloudformation.model.CallAs] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ListStackInstancesRequest = {
    import ListStackInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ListStackInstancesRequest
      .builder()
      .stackSetName(StackSetName.unwrap(stackSetName): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        stackInstanceAccount.map(value =>
          Account.unwrap(value): java.lang.String
        )
      )(_.stackInstanceAccount)
      .optionallyWith(
        stackInstanceRegion.map(value => Region.unwrap(value): java.lang.String)
      )(_.stackInstanceRegion)
      .optionallyWith(callAs.map(value => value.unwrap))(_.callAs)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.ListStackInstancesRequest.ReadOnly =
    zio.aws.cloudformation.model.ListStackInstancesRequest.wrap(buildAwsValue())
}
object ListStackInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ListStackInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ListStackInstancesRequest =
      zio.aws.cloudformation.model.ListStackInstancesRequest(
        stackSetName,
        nextToken.map(value => value),
        maxResults.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        stackInstanceAccount.map(value => value),
        stackInstanceRegion.map(value => value),
        callAs.map(value => value)
      )
    def stackSetName: StackSetName
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def filters: Optional[
      List[zio.aws.cloudformation.model.StackInstanceFilter.ReadOnly]
    ]
    def stackInstanceAccount: Optional[Account]
    def stackInstanceRegion: Optional[Region]
    def callAs: Optional[zio.aws.cloudformation.model.CallAs]
    def getStackSetName: ZIO[Any, Nothing, StackSetName] =
      ZIO.succeed(stackSetName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.StackInstanceFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getStackInstanceAccount: ZIO[Any, AwsError, Account] =
      AwsError.unwrapOptionField("stackInstanceAccount", stackInstanceAccount)
    def getStackInstanceRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("stackInstanceRegion", stackInstanceRegion)
    def getCallAs: ZIO[Any, AwsError, zio.aws.cloudformation.model.CallAs] =
      AwsError.unwrapOptionField("callAs", callAs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ListStackInstancesRequest
  ) extends zio.aws.cloudformation.model.ListStackInstancesRequest.ReadOnly {
    override val stackSetName: StackSetName =
      zio.aws.cloudformation.model.primitives.StackSetName(impl.stackSetName())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.cloudformation.model.primitives.MaxResults(value))
    override val filters: Optional[
      List[zio.aws.cloudformation.model.StackInstanceFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.StackInstanceFilter.wrap(item)
        }.toList
      )
    override val stackInstanceAccount: Optional[Account] = zio.aws.core.internal
      .optionalFromNullable(impl.stackInstanceAccount())
      .map(value => zio.aws.cloudformation.model.primitives.Account(value))
    override val stackInstanceRegion: Optional[Region] = zio.aws.core.internal
      .optionalFromNullable(impl.stackInstanceRegion())
      .map(value => zio.aws.cloudformation.model.primitives.Region(value))
    override val callAs: Optional[zio.aws.cloudformation.model.CallAs] =
      zio.aws.core.internal
        .optionalFromNullable(impl.callAs())
        .map(value => zio.aws.cloudformation.model.CallAs.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ListStackInstancesRequest
  ): zio.aws.cloudformation.model.ListStackInstancesRequest.ReadOnly =
    new Wrapper(impl)
}
