package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListStacksResponse(
    stackSummaries: Optional[
      Iterable[zio.aws.cloudformation.model.StackSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ListStacksResponse = {
    import ListStacksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ListStacksResponse
      .builder()
      .optionallyWith(
        stackSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.stackSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.ListStacksResponse.ReadOnly =
    zio.aws.cloudformation.model.ListStacksResponse.wrap(buildAwsValue())
}
object ListStacksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ListStacksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ListStacksResponse =
      zio.aws.cloudformation.model.ListStacksResponse(
        stackSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def stackSummaries
        : Optional[List[zio.aws.cloudformation.model.StackSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getStackSummaries: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.StackSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("stackSummaries", stackSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ListStacksResponse
  ) extends zio.aws.cloudformation.model.ListStacksResponse.ReadOnly {
    override val stackSummaries
        : Optional[List[zio.aws.cloudformation.model.StackSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stackSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.StackSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ListStacksResponse
  ): zio.aws.cloudformation.model.ListStacksResponse.ReadOnly = new Wrapper(
    impl
  )
}
