package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait OrganizationStatus {
  def unwrap
      : software.amazon.awssdk.services.cloudformation.model.OrganizationStatus
}
object OrganizationStatus {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.OrganizationStatus
  ): zio.aws.cloudformation.model.OrganizationStatus = value match {
    case software.amazon.awssdk.services.cloudformation.model.OrganizationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.OrganizationStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.cloudformation.model.OrganizationStatus.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.cloudformation.model.OrganizationStatus.DISABLED_PERMANENTLY =>
      val r = DISABLED_PERMANENTLY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.OrganizationStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.OrganizationStatus =
      software.amazon.awssdk.services.cloudformation.model.OrganizationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.cloudformation.model.OrganizationStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.OrganizationStatus =
      software.amazon.awssdk.services.cloudformation.model.OrganizationStatus.ENABLED
  }
  case object DISABLED extends zio.aws.cloudformation.model.OrganizationStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.OrganizationStatus =
      software.amazon.awssdk.services.cloudformation.model.OrganizationStatus.DISABLED
  }
  case object DISABLED_PERMANENTLY
      extends zio.aws.cloudformation.model.OrganizationStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.OrganizationStatus =
      software.amazon.awssdk.services.cloudformation.model.OrganizationStatus.DISABLED_PERMANENTLY
  }
}
