package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  UsePreviousValue,
  ParameterValue,
  ParameterKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Parameter(
    parameterKey: Optional[ParameterKey] = Optional.Absent,
    parameterValue: Optional[ParameterValue] = Optional.Absent,
    usePreviousValue: Optional[UsePreviousValue] = Optional.Absent,
    resolvedValue: Optional[ParameterValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.Parameter = {
    import Parameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.Parameter
      .builder()
      .optionallyWith(
        parameterKey.map(value => ParameterKey.unwrap(value): java.lang.String)
      )(_.parameterKey)
      .optionallyWith(
        parameterValue.map(value =>
          ParameterValue.unwrap(value): java.lang.String
        )
      )(_.parameterValue)
      .optionallyWith(
        usePreviousValue.map(value =>
          UsePreviousValue.unwrap(value): java.lang.Boolean
        )
      )(_.usePreviousValue)
      .optionallyWith(
        resolvedValue.map(value =>
          ParameterValue.unwrap(value): java.lang.String
        )
      )(_.resolvedValue)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.Parameter.ReadOnly =
    zio.aws.cloudformation.model.Parameter.wrap(buildAwsValue())
}
object Parameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.Parameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.Parameter =
      zio.aws.cloudformation.model.Parameter(
        parameterKey.map(value => value),
        parameterValue.map(value => value),
        usePreviousValue.map(value => value),
        resolvedValue.map(value => value)
      )
    def parameterKey: Optional[ParameterKey]
    def parameterValue: Optional[ParameterValue]
    def usePreviousValue: Optional[UsePreviousValue]
    def resolvedValue: Optional[ParameterValue]
    def getParameterKey: ZIO[Any, AwsError, ParameterKey] =
      AwsError.unwrapOptionField("parameterKey", parameterKey)
    def getParameterValue: ZIO[Any, AwsError, ParameterValue] =
      AwsError.unwrapOptionField("parameterValue", parameterValue)
    def getUsePreviousValue: ZIO[Any, AwsError, UsePreviousValue] =
      AwsError.unwrapOptionField("usePreviousValue", usePreviousValue)
    def getResolvedValue: ZIO[Any, AwsError, ParameterValue] =
      AwsError.unwrapOptionField("resolvedValue", resolvedValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.Parameter
  ) extends zio.aws.cloudformation.model.Parameter.ReadOnly {
    override val parameterKey: Optional[ParameterKey] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterKey())
      .map(value => zio.aws.cloudformation.model.primitives.ParameterKey(value))
    override val parameterValue: Optional[ParameterValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameterValue())
        .map(value =>
          zio.aws.cloudformation.model.primitives.ParameterValue(value)
        )
    override val usePreviousValue: Optional[UsePreviousValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usePreviousValue())
        .map(value =>
          zio.aws.cloudformation.model.primitives.UsePreviousValue(value)
        )
    override val resolvedValue: Optional[ParameterValue] = zio.aws.core.internal
      .optionalFromNullable(impl.resolvedValue())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ParameterValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.Parameter
  ): zio.aws.cloudformation.model.Parameter.ReadOnly = new Wrapper(impl)
}
