package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  ParameterKey,
  ParameterValue,
  NoEcho,
  Description,
  ParameterType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ParameterDeclaration(
    parameterKey: Optional[ParameterKey] = Optional.Absent,
    defaultValue: Optional[ParameterValue] = Optional.Absent,
    parameterType: Optional[ParameterType] = Optional.Absent,
    noEcho: Optional[NoEcho] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    parameterConstraints: Optional[
      zio.aws.cloudformation.model.ParameterConstraints
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ParameterDeclaration = {
    import ParameterDeclaration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ParameterDeclaration
      .builder()
      .optionallyWith(
        parameterKey.map(value => ParameterKey.unwrap(value): java.lang.String)
      )(_.parameterKey)
      .optionallyWith(
        defaultValue.map(value =>
          ParameterValue.unwrap(value): java.lang.String
        )
      )(_.defaultValue)
      .optionallyWith(
        parameterType.map(value =>
          ParameterType.unwrap(value): java.lang.String
        )
      )(_.parameterType)
      .optionallyWith(
        noEcho.map(value => NoEcho.unwrap(value): java.lang.Boolean)
      )(_.noEcho)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(parameterConstraints.map(value => value.buildAwsValue()))(
        _.parameterConstraints
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.ParameterDeclaration.ReadOnly =
    zio.aws.cloudformation.model.ParameterDeclaration.wrap(buildAwsValue())
}
object ParameterDeclaration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ParameterDeclaration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ParameterDeclaration =
      zio.aws.cloudformation.model.ParameterDeclaration(
        parameterKey.map(value => value),
        defaultValue.map(value => value),
        parameterType.map(value => value),
        noEcho.map(value => value),
        description.map(value => value),
        parameterConstraints.map(value => value.asEditable)
      )
    def parameterKey: Optional[ParameterKey]
    def defaultValue: Optional[ParameterValue]
    def parameterType: Optional[ParameterType]
    def noEcho: Optional[NoEcho]
    def description: Optional[Description]
    def parameterConstraints
        : Optional[zio.aws.cloudformation.model.ParameterConstraints.ReadOnly]
    def getParameterKey: ZIO[Any, AwsError, ParameterKey] =
      AwsError.unwrapOptionField("parameterKey", parameterKey)
    def getDefaultValue: ZIO[Any, AwsError, ParameterValue] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getParameterType: ZIO[Any, AwsError, ParameterType] =
      AwsError.unwrapOptionField("parameterType", parameterType)
    def getNoEcho: ZIO[Any, AwsError, NoEcho] =
      AwsError.unwrapOptionField("noEcho", noEcho)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getParameterConstraints: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.ParameterConstraints.ReadOnly
    ] = AwsError.unwrapOptionField("parameterConstraints", parameterConstraints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ParameterDeclaration
  ) extends zio.aws.cloudformation.model.ParameterDeclaration.ReadOnly {
    override val parameterKey: Optional[ParameterKey] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterKey())
      .map(value => zio.aws.cloudformation.model.primitives.ParameterKey(value))
    override val defaultValue: Optional[ParameterValue] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultValue())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ParameterValue(value)
      )
    override val parameterType: Optional[ParameterType] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterType())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ParameterType(value)
      )
    override val noEcho: Optional[NoEcho] = zio.aws.core.internal
      .optionalFromNullable(impl.noEcho())
      .map(value => zio.aws.cloudformation.model.primitives.NoEcho(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.cloudformation.model.primitives.Description(value))
    override val parameterConstraints
        : Optional[zio.aws.cloudformation.model.ParameterConstraints.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameterConstraints())
        .map(value =>
          zio.aws.cloudformation.model.ParameterConstraints.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ParameterDeclaration
  ): zio.aws.cloudformation.model.ParameterDeclaration.ReadOnly = new Wrapper(
    impl
  )
}
