package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait PermissionModels {
  def unwrap
      : software.amazon.awssdk.services.cloudformation.model.PermissionModels
}
object PermissionModels {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.PermissionModels
  ): zio.aws.cloudformation.model.PermissionModels = value match {
    case software.amazon.awssdk.services.cloudformation.model.PermissionModels.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.PermissionModels.SERVICE_MANAGED =>
      val r = SERVICE_MANAGED
      r
    case software.amazon.awssdk.services.cloudformation.model.PermissionModels.SELF_MANAGED =>
      val r = SELF_MANAGED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.PermissionModels {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.PermissionModels =
      software.amazon.awssdk.services.cloudformation.model.PermissionModels.UNKNOWN_TO_SDK_VERSION
  }
  case object SERVICE_MANAGED
      extends zio.aws.cloudformation.model.PermissionModels {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.PermissionModels =
      software.amazon.awssdk.services.cloudformation.model.PermissionModels.SERVICE_MANAGED
  }
  case object SELF_MANAGED
      extends zio.aws.cloudformation.model.PermissionModels {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.PermissionModels =
      software.amazon.awssdk.services.cloudformation.model.PermissionModels.SELF_MANAGED
  }
}
