package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{Value, Key}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PhysicalResourceIdContextKeyValuePair(key: Key, value: Value) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.PhysicalResourceIdContextKeyValuePair = {
    import PhysicalResourceIdContextKeyValuePair.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.PhysicalResourceIdContextKeyValuePair
      .builder()
      .key(Key.unwrap(key): java.lang.String)
      .value(Value.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.PhysicalResourceIdContextKeyValuePair.ReadOnly =
    zio.aws.cloudformation.model.PhysicalResourceIdContextKeyValuePair
      .wrap(buildAwsValue())
}
object PhysicalResourceIdContextKeyValuePair {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.PhysicalResourceIdContextKeyValuePair
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudformation.model.PhysicalResourceIdContextKeyValuePair =
      zio.aws.cloudformation.model
        .PhysicalResourceIdContextKeyValuePair(key, value)
    def key: Key
    def value: Value
    def getKey: ZIO[Any, Nothing, Key] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, Value] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.PhysicalResourceIdContextKeyValuePair
  ) extends zio.aws.cloudformation.model.PhysicalResourceIdContextKeyValuePair.ReadOnly {
    override val key: Key =
      zio.aws.cloudformation.model.primitives.Key(impl.key())
    override val value: Value =
      zio.aws.cloudformation.model.primitives.Value(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.PhysicalResourceIdContextKeyValuePair
  ): zio.aws.cloudformation.model.PhysicalResourceIdContextKeyValuePair.ReadOnly =
    new Wrapper(impl)
}
