package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{PropertyValue, PropertyPath}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PropertyDifference(
    propertyPath: PropertyPath,
    expectedValue: PropertyValue,
    actualValue: PropertyValue,
    differenceType: zio.aws.cloudformation.model.DifferenceType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.PropertyDifference = {
    import PropertyDifference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.PropertyDifference
      .builder()
      .propertyPath(PropertyPath.unwrap(propertyPath): java.lang.String)
      .expectedValue(PropertyValue.unwrap(expectedValue): java.lang.String)
      .actualValue(PropertyValue.unwrap(actualValue): java.lang.String)
      .differenceType(differenceType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.PropertyDifference.ReadOnly =
    zio.aws.cloudformation.model.PropertyDifference.wrap(buildAwsValue())
}
object PropertyDifference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.PropertyDifference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.PropertyDifference =
      zio.aws.cloudformation.model.PropertyDifference(
        propertyPath,
        expectedValue,
        actualValue,
        differenceType
      )
    def propertyPath: PropertyPath
    def expectedValue: PropertyValue
    def actualValue: PropertyValue
    def differenceType: zio.aws.cloudformation.model.DifferenceType
    def getPropertyPath: ZIO[Any, Nothing, PropertyPath] =
      ZIO.succeed(propertyPath)
    def getExpectedValue: ZIO[Any, Nothing, PropertyValue] =
      ZIO.succeed(expectedValue)
    def getActualValue: ZIO[Any, Nothing, PropertyValue] =
      ZIO.succeed(actualValue)
    def getDifferenceType
        : ZIO[Any, Nothing, zio.aws.cloudformation.model.DifferenceType] =
      ZIO.succeed(differenceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.PropertyDifference
  ) extends zio.aws.cloudformation.model.PropertyDifference.ReadOnly {
    override val propertyPath: PropertyPath =
      zio.aws.cloudformation.model.primitives.PropertyPath(impl.propertyPath())
    override val expectedValue: PropertyValue =
      zio.aws.cloudformation.model.primitives
        .PropertyValue(impl.expectedValue())
    override val actualValue: PropertyValue =
      zio.aws.cloudformation.model.primitives.PropertyValue(impl.actualValue())
    override val differenceType: zio.aws.cloudformation.model.DifferenceType =
      zio.aws.cloudformation.model.DifferenceType.wrap(impl.differenceType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.PropertyDifference
  ): zio.aws.cloudformation.model.PropertyDifference.ReadOnly = new Wrapper(
    impl
  )
}
