package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  PublicVersionNumber,
  TypeName,
  PrivateTypeArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PublishTypeRequest(
    `type`: Optional[zio.aws.cloudformation.model.ThirdPartyType] =
      Optional.Absent,
    arn: Optional[PrivateTypeArn] = Optional.Absent,
    typeName: Optional[TypeName] = Optional.Absent,
    publicVersionNumber: Optional[PublicVersionNumber] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.PublishTypeRequest = {
    import PublishTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.PublishTypeRequest
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        arn.map(value => PrivateTypeArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        typeName.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.typeName)
      .optionallyWith(
        publicVersionNumber.map(value =>
          PublicVersionNumber.unwrap(value): java.lang.String
        )
      )(_.publicVersionNumber)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.PublishTypeRequest.ReadOnly =
    zio.aws.cloudformation.model.PublishTypeRequest.wrap(buildAwsValue())
}
object PublishTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.PublishTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.PublishTypeRequest =
      zio.aws.cloudformation.model.PublishTypeRequest(
        `type`.map(value => value),
        arn.map(value => value),
        typeName.map(value => value),
        publicVersionNumber.map(value => value)
      )
    def `type`: Optional[zio.aws.cloudformation.model.ThirdPartyType]
    def arn: Optional[PrivateTypeArn]
    def typeName: Optional[TypeName]
    def publicVersionNumber: Optional[PublicVersionNumber]
    def getType
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.ThirdPartyType] =
      AwsError.unwrapOptionField("type", `type`)
    def getArn: ZIO[Any, AwsError, PrivateTypeArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getTypeName: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getPublicVersionNumber: ZIO[Any, AwsError, PublicVersionNumber] =
      AwsError.unwrapOptionField("publicVersionNumber", publicVersionNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.PublishTypeRequest
  ) extends zio.aws.cloudformation.model.PublishTypeRequest.ReadOnly {
    override val `type`: Optional[zio.aws.cloudformation.model.ThirdPartyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.cloudformation.model.ThirdPartyType.wrap(value))
    override val arn: Optional[PrivateTypeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.cloudformation.model.primitives.PrivateTypeArn(value)
      )
    override val typeName: Optional[TypeName] = zio.aws.core.internal
      .optionalFromNullable(impl.typeName())
      .map(value => zio.aws.cloudformation.model.primitives.TypeName(value))
    override val publicVersionNumber: Optional[PublicVersionNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publicVersionNumber())
        .map(value =>
          zio.aws.cloudformation.model.primitives.PublicVersionNumber(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.PublishTypeRequest
  ): zio.aws.cloudformation.model.PublishTypeRequest.ReadOnly = new Wrapper(
    impl
  )
}
