package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait PublisherStatus {
  def unwrap
      : software.amazon.awssdk.services.cloudformation.model.PublisherStatus
}
object PublisherStatus {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.PublisherStatus
  ): zio.aws.cloudformation.model.PublisherStatus = value match {
    case software.amazon.awssdk.services.cloudformation.model.PublisherStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.PublisherStatus.VERIFIED =>
      val r = VERIFIED
      r
    case software.amazon.awssdk.services.cloudformation.model.PublisherStatus.UNVERIFIED =>
      val r = UNVERIFIED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.PublisherStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.PublisherStatus =
      software.amazon.awssdk.services.cloudformation.model.PublisherStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object VERIFIED extends zio.aws.cloudformation.model.PublisherStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.PublisherStatus =
      software.amazon.awssdk.services.cloudformation.model.PublisherStatus.VERIFIED
  }
  case object UNVERIFIED extends zio.aws.cloudformation.model.PublisherStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.PublisherStatus =
      software.amazon.awssdk.services.cloudformation.model.PublisherStatus.UNVERIFIED
  }
}
