package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait RegionConcurrencyType {
  def unwrap: software.amazon.awssdk.services.cloudformation.model.RegionConcurrencyType
}
object RegionConcurrencyType {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.RegionConcurrencyType
  ): zio.aws.cloudformation.model.RegionConcurrencyType = value match {
    case software.amazon.awssdk.services.cloudformation.model.RegionConcurrencyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.RegionConcurrencyType.SEQUENTIAL =>
      val r = SEQUENTIAL
      r
    case software.amazon.awssdk.services.cloudformation.model.RegionConcurrencyType.PARALLEL =>
      val r = PARALLEL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.RegionConcurrencyType {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.RegionConcurrencyType =
      software.amazon.awssdk.services.cloudformation.model.RegionConcurrencyType.UNKNOWN_TO_SDK_VERSION
  }
  case object SEQUENTIAL
      extends zio.aws.cloudformation.model.RegionConcurrencyType {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.RegionConcurrencyType =
      software.amazon.awssdk.services.cloudformation.model.RegionConcurrencyType.SEQUENTIAL
  }
  case object PARALLEL
      extends zio.aws.cloudformation.model.RegionConcurrencyType {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.RegionConcurrencyType =
      software.amazon.awssdk.services.cloudformation.model.RegionConcurrencyType.PARALLEL
  }
}
