package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.PublisherId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RegisterPublisherResponse(
    publisherId: Optional[PublisherId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.RegisterPublisherResponse = {
    import RegisterPublisherResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.RegisterPublisherResponse
      .builder()
      .optionallyWith(
        publisherId.map(value => PublisherId.unwrap(value): java.lang.String)
      )(_.publisherId)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.RegisterPublisherResponse.ReadOnly =
    zio.aws.cloudformation.model.RegisterPublisherResponse.wrap(buildAwsValue())
}
object RegisterPublisherResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.RegisterPublisherResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.RegisterPublisherResponse =
      zio.aws.cloudformation.model
        .RegisterPublisherResponse(publisherId.map(value => value))
    def publisherId: Optional[PublisherId]
    def getPublisherId: ZIO[Any, AwsError, PublisherId] =
      AwsError.unwrapOptionField("publisherId", publisherId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.RegisterPublisherResponse
  ) extends zio.aws.cloudformation.model.RegisterPublisherResponse.ReadOnly {
    override val publisherId: Optional[PublisherId] = zio.aws.core.internal
      .optionalFromNullable(impl.publisherId())
      .map(value => zio.aws.cloudformation.model.primitives.PublisherId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.RegisterPublisherResponse
  ): zio.aws.cloudformation.model.RegisterPublisherResponse.ReadOnly =
    new Wrapper(impl)
}
