package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait RegistryType {
  def unwrap: software.amazon.awssdk.services.cloudformation.model.RegistryType
}
object RegistryType {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.RegistryType
  ): zio.aws.cloudformation.model.RegistryType = value match {
    case software.amazon.awssdk.services.cloudformation.model.RegistryType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.RegistryType.RESOURCE =>
      val r = RESOURCE
      r
    case software.amazon.awssdk.services.cloudformation.model.RegistryType.MODULE =>
      val r = MODULE
      r
    case software.amazon.awssdk.services.cloudformation.model.RegistryType.HOOK =>
      val r = HOOK
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.RegistryType {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.RegistryType =
      software.amazon.awssdk.services.cloudformation.model.RegistryType.UNKNOWN_TO_SDK_VERSION
  }
  case object RESOURCE extends zio.aws.cloudformation.model.RegistryType {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.RegistryType =
      software.amazon.awssdk.services.cloudformation.model.RegistryType.RESOURCE
  }
  case object MODULE extends zio.aws.cloudformation.model.RegistryType {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.RegistryType =
      software.amazon.awssdk.services.cloudformation.model.RegistryType.MODULE
  }
  case object HOOK extends zio.aws.cloudformation.model.RegistryType {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.RegistryType =
      software.amazon.awssdk.services.cloudformation.model.RegistryType.HOOK
  }
}
