package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  ChangeSetId,
  ResourceType,
  PhysicalResourceId,
  LogicalResourceId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResourceChange(
    action: Optional[zio.aws.cloudformation.model.ChangeAction] =
      Optional.Absent,
    logicalResourceId: Optional[LogicalResourceId] = Optional.Absent,
    physicalResourceId: Optional[PhysicalResourceId] = Optional.Absent,
    resourceType: Optional[ResourceType] = Optional.Absent,
    replacement: Optional[zio.aws.cloudformation.model.Replacement] =
      Optional.Absent,
    scope: Optional[Iterable[zio.aws.cloudformation.model.ResourceAttribute]] =
      Optional.Absent,
    details: Optional[
      Iterable[zio.aws.cloudformation.model.ResourceChangeDetail]
    ] = Optional.Absent,
    changeSetId: Optional[ChangeSetId] = Optional.Absent,
    moduleInfo: Optional[zio.aws.cloudformation.model.ModuleInfo] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ResourceChange = {
    import ResourceChange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ResourceChange
      .builder()
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(
        logicalResourceId.map(value =>
          LogicalResourceId.unwrap(value): java.lang.String
        )
      )(_.logicalResourceId)
      .optionallyWith(
        physicalResourceId.map(value =>
          PhysicalResourceId.unwrap(value): java.lang.String
        )
      )(_.physicalResourceId)
      .optionallyWith(
        resourceType.map(value => ResourceType.unwrap(value): java.lang.String)
      )(_.resourceType)
      .optionallyWith(replacement.map(value => value.unwrap))(_.replacement)
      .optionallyWith(
        scope.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.scopeWithStrings)
      .optionallyWith(
        details.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.details)
      .optionallyWith(
        changeSetId.map(value => ChangeSetId.unwrap(value): java.lang.String)
      )(_.changeSetId)
      .optionallyWith(moduleInfo.map(value => value.buildAwsValue()))(
        _.moduleInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.ResourceChange.ReadOnly =
    zio.aws.cloudformation.model.ResourceChange.wrap(buildAwsValue())
}
object ResourceChange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ResourceChange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ResourceChange =
      zio.aws.cloudformation.model.ResourceChange(
        action.map(value => value),
        logicalResourceId.map(value => value),
        physicalResourceId.map(value => value),
        resourceType.map(value => value),
        replacement.map(value => value),
        scope.map(value => value),
        details.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        changeSetId.map(value => value),
        moduleInfo.map(value => value.asEditable)
      )
    def action: Optional[zio.aws.cloudformation.model.ChangeAction]
    def logicalResourceId: Optional[LogicalResourceId]
    def physicalResourceId: Optional[PhysicalResourceId]
    def resourceType: Optional[ResourceType]
    def replacement: Optional[zio.aws.cloudformation.model.Replacement]
    def scope: Optional[List[zio.aws.cloudformation.model.ResourceAttribute]]
    def details: Optional[
      List[zio.aws.cloudformation.model.ResourceChangeDetail.ReadOnly]
    ]
    def changeSetId: Optional[ChangeSetId]
    def moduleInfo: Optional[zio.aws.cloudformation.model.ModuleInfo.ReadOnly]
    def getAction
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.ChangeAction] =
      AwsError.unwrapOptionField("action", action)
    def getLogicalResourceId: ZIO[Any, AwsError, LogicalResourceId] =
      AwsError.unwrapOptionField("logicalResourceId", logicalResourceId)
    def getPhysicalResourceId: ZIO[Any, AwsError, PhysicalResourceId] =
      AwsError.unwrapOptionField("physicalResourceId", physicalResourceId)
    def getResourceType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getReplacement
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.Replacement] =
      AwsError.unwrapOptionField("replacement", replacement)
    def getScope: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.ResourceAttribute
    ]] = AwsError.unwrapOptionField("scope", scope)
    def getDetails: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.ResourceChangeDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("details", details)
    def getChangeSetId: ZIO[Any, AwsError, ChangeSetId] =
      AwsError.unwrapOptionField("changeSetId", changeSetId)
    def getModuleInfo
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.ModuleInfo.ReadOnly] =
      AwsError.unwrapOptionField("moduleInfo", moduleInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ResourceChange
  ) extends zio.aws.cloudformation.model.ResourceChange.ReadOnly {
    override val action: Optional[zio.aws.cloudformation.model.ChangeAction] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value => zio.aws.cloudformation.model.ChangeAction.wrap(value))
    override val logicalResourceId: Optional[LogicalResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logicalResourceId())
        .map(value =>
          zio.aws.cloudformation.model.primitives.LogicalResourceId(value)
        )
    override val physicalResourceId: Optional[PhysicalResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.physicalResourceId())
        .map(value =>
          zio.aws.cloudformation.model.primitives.PhysicalResourceId(value)
        )
    override val resourceType: Optional[ResourceType] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceType())
      .map(value => zio.aws.cloudformation.model.primitives.ResourceType(value))
    override val replacement
        : Optional[zio.aws.cloudformation.model.Replacement] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replacement())
        .map(value => zio.aws.cloudformation.model.Replacement.wrap(value))
    override val scope
        : Optional[List[zio.aws.cloudformation.model.ResourceAttribute]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scope())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.ResourceAttribute.wrap(item)
          }.toList
        )
    override val details: Optional[
      List[zio.aws.cloudformation.model.ResourceChangeDetail.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.details())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.ResourceChangeDetail.wrap(item)
        }.toList
      )
    override val changeSetId: Optional[ChangeSetId] = zio.aws.core.internal
      .optionalFromNullable(impl.changeSetId())
      .map(value => zio.aws.cloudformation.model.primitives.ChangeSetId(value))
    override val moduleInfo
        : Optional[zio.aws.cloudformation.model.ModuleInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.moduleInfo())
        .map(value => zio.aws.cloudformation.model.ModuleInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ResourceChange
  ): zio.aws.cloudformation.model.ResourceChange.ReadOnly = new Wrapper(impl)
}
