package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait ResourceSignalStatus {
  def unwrap: software.amazon.awssdk.services.cloudformation.model.ResourceSignalStatus
}
object ResourceSignalStatus {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.ResourceSignalStatus
  ): zio.aws.cloudformation.model.ResourceSignalStatus = value match {
    case software.amazon.awssdk.services.cloudformation.model.ResourceSignalStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.ResourceSignalStatus.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.cloudformation.model.ResourceSignalStatus.FAILURE =>
      val r = FAILURE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.ResourceSignalStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ResourceSignalStatus =
      software.amazon.awssdk.services.cloudformation.model.ResourceSignalStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object SUCCESS
      extends zio.aws.cloudformation.model.ResourceSignalStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ResourceSignalStatus =
      software.amazon.awssdk.services.cloudformation.model.ResourceSignalStatus.SUCCESS
  }
  case object FAILURE
      extends zio.aws.cloudformation.model.ResourceSignalStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ResourceSignalStatus =
      software.amazon.awssdk.services.cloudformation.model.ResourceSignalStatus.FAILURE
  }
}
