package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.PropertyName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResourceTargetDefinition(
    attribute: Optional[zio.aws.cloudformation.model.ResourceAttribute] =
      Optional.Absent,
    name: Optional[PropertyName] = Optional.Absent,
    requiresRecreation: Optional[
      zio.aws.cloudformation.model.RequiresRecreation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ResourceTargetDefinition = {
    import ResourceTargetDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ResourceTargetDefinition
      .builder()
      .optionallyWith(attribute.map(value => value.unwrap))(_.attribute)
      .optionallyWith(
        name.map(value => PropertyName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(requiresRecreation.map(value => value.unwrap))(
        _.requiresRecreation
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.ResourceTargetDefinition.ReadOnly =
    zio.aws.cloudformation.model.ResourceTargetDefinition.wrap(buildAwsValue())
}
object ResourceTargetDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ResourceTargetDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ResourceTargetDefinition =
      zio.aws.cloudformation.model.ResourceTargetDefinition(
        attribute.map(value => value),
        name.map(value => value),
        requiresRecreation.map(value => value)
      )
    def attribute: Optional[zio.aws.cloudformation.model.ResourceAttribute]
    def name: Optional[PropertyName]
    def requiresRecreation
        : Optional[zio.aws.cloudformation.model.RequiresRecreation]
    def getAttribute
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.ResourceAttribute] =
      AwsError.unwrapOptionField("attribute", attribute)
    def getName: ZIO[Any, AwsError, PropertyName] =
      AwsError.unwrapOptionField("name", name)
    def getRequiresRecreation
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.RequiresRecreation] =
      AwsError.unwrapOptionField("requiresRecreation", requiresRecreation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ResourceTargetDefinition
  ) extends zio.aws.cloudformation.model.ResourceTargetDefinition.ReadOnly {
    override val attribute
        : Optional[zio.aws.cloudformation.model.ResourceAttribute] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attribute())
        .map(value =>
          zio.aws.cloudformation.model.ResourceAttribute.wrap(value)
        )
    override val name: Optional[PropertyName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.cloudformation.model.primitives.PropertyName(value))
    override val requiresRecreation
        : Optional[zio.aws.cloudformation.model.RequiresRecreation] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requiresRecreation())
        .map(value =>
          zio.aws.cloudformation.model.RequiresRecreation.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ResourceTargetDefinition
  ): zio.aws.cloudformation.model.ResourceTargetDefinition.ReadOnly =
    new Wrapper(impl)
}
