package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  StackPolicyURL,
  StackPolicyBody,
  StackName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SetStackPolicyRequest(
    stackName: StackName,
    stackPolicyBody: Optional[StackPolicyBody] = Optional.Absent,
    stackPolicyURL: Optional[StackPolicyURL] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.SetStackPolicyRequest = {
    import SetStackPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.SetStackPolicyRequest
      .builder()
      .stackName(StackName.unwrap(stackName): java.lang.String)
      .optionallyWith(
        stackPolicyBody.map(value =>
          StackPolicyBody.unwrap(value): java.lang.String
        )
      )(_.stackPolicyBody)
      .optionallyWith(
        stackPolicyURL.map(value =>
          StackPolicyURL.unwrap(value): java.lang.String
        )
      )(_.stackPolicyURL)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.SetStackPolicyRequest.ReadOnly =
    zio.aws.cloudformation.model.SetStackPolicyRequest.wrap(buildAwsValue())
}
object SetStackPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.SetStackPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.SetStackPolicyRequest =
      zio.aws.cloudformation.model.SetStackPolicyRequest(
        stackName,
        stackPolicyBody.map(value => value),
        stackPolicyURL.map(value => value)
      )
    def stackName: StackName
    def stackPolicyBody: Optional[StackPolicyBody]
    def stackPolicyURL: Optional[StackPolicyURL]
    def getStackName: ZIO[Any, Nothing, StackName] = ZIO.succeed(stackName)
    def getStackPolicyBody: ZIO[Any, AwsError, StackPolicyBody] =
      AwsError.unwrapOptionField("stackPolicyBody", stackPolicyBody)
    def getStackPolicyURL: ZIO[Any, AwsError, StackPolicyURL] =
      AwsError.unwrapOptionField("stackPolicyURL", stackPolicyURL)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.SetStackPolicyRequest
  ) extends zio.aws.cloudformation.model.SetStackPolicyRequest.ReadOnly {
    override val stackName: StackName =
      zio.aws.cloudformation.model.primitives.StackName(impl.stackName())
    override val stackPolicyBody: Optional[StackPolicyBody] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stackPolicyBody())
        .map(value =>
          zio.aws.cloudformation.model.primitives.StackPolicyBody(value)
        )
    override val stackPolicyURL: Optional[StackPolicyURL] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stackPolicyURL())
        .map(value =>
          zio.aws.cloudformation.model.primitives.StackPolicyURL(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.SetStackPolicyRequest
  ): zio.aws.cloudformation.model.SetStackPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
