package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait StackDriftStatus {
  def unwrap
      : software.amazon.awssdk.services.cloudformation.model.StackDriftStatus
}
object StackDriftStatus {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.StackDriftStatus
  ): zio.aws.cloudformation.model.StackDriftStatus = value match {
    case software.amazon.awssdk.services.cloudformation.model.StackDriftStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.StackDriftStatus.DRIFTED =>
      val r = DRIFTED
      r
    case software.amazon.awssdk.services.cloudformation.model.StackDriftStatus.IN_SYNC =>
      val r = IN_SYNC
      r
    case software.amazon.awssdk.services.cloudformation.model.StackDriftStatus.UNKNOWN =>
      val r = UNKNOWN
      r
    case software.amazon.awssdk.services.cloudformation.model.StackDriftStatus.NOT_CHECKED =>
      val r = NOT_CHECKED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.StackDriftStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackDriftStatus =
      software.amazon.awssdk.services.cloudformation.model.StackDriftStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object DRIFTED extends zio.aws.cloudformation.model.StackDriftStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackDriftStatus =
      software.amazon.awssdk.services.cloudformation.model.StackDriftStatus.DRIFTED
  }
  case object IN_SYNC extends zio.aws.cloudformation.model.StackDriftStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackDriftStatus =
      software.amazon.awssdk.services.cloudformation.model.StackDriftStatus.IN_SYNC
  }
  case object UNKNOWN extends zio.aws.cloudformation.model.StackDriftStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackDriftStatus =
      software.amazon.awssdk.services.cloudformation.model.StackDriftStatus.UNKNOWN
  }
  case object NOT_CHECKED
      extends zio.aws.cloudformation.model.StackDriftStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackDriftStatus =
      software.amazon.awssdk.services.cloudformation.model.StackDriftStatus.NOT_CHECKED
  }
}
