package zio.aws.cloudformation.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudformation.model.primitives.{
  LogicalResourceId,
  StackName,
  Timestamp,
  StackId,
  ResourceStatusReason,
  PhysicalResourceId,
  ResourceType,
  Description
}
import scala.jdk.CollectionConverters._
final case class StackResource(
    stackName: Optional[StackName] = Optional.Absent,
    stackId: Optional[StackId] = Optional.Absent,
    logicalResourceId: LogicalResourceId,
    physicalResourceId: Optional[PhysicalResourceId] = Optional.Absent,
    resourceType: ResourceType,
    timestamp: Timestamp,
    resourceStatus: zio.aws.cloudformation.model.ResourceStatus,
    resourceStatusReason: Optional[ResourceStatusReason] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    driftInformation: Optional[
      zio.aws.cloudformation.model.StackResourceDriftInformation
    ] = Optional.Absent,
    moduleInfo: Optional[zio.aws.cloudformation.model.ModuleInfo] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.StackResource = {
    import StackResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.StackResource
      .builder()
      .optionallyWith(
        stackName.map(value => StackName.unwrap(value): java.lang.String)
      )(_.stackName)
      .optionallyWith(
        stackId.map(value => StackId.unwrap(value): java.lang.String)
      )(_.stackId)
      .logicalResourceId(
        LogicalResourceId.unwrap(logicalResourceId): java.lang.String
      )
      .optionallyWith(
        physicalResourceId.map(value =>
          PhysicalResourceId.unwrap(value): java.lang.String
        )
      )(_.physicalResourceId)
      .resourceType(ResourceType.unwrap(resourceType): java.lang.String)
      .timestamp(Timestamp.unwrap(timestamp): Instant)
      .resourceStatus(resourceStatus.unwrap)
      .optionallyWith(
        resourceStatusReason.map(value =>
          ResourceStatusReason.unwrap(value): java.lang.String
        )
      )(_.resourceStatusReason)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(driftInformation.map(value => value.buildAwsValue()))(
        _.driftInformation
      )
      .optionallyWith(moduleInfo.map(value => value.buildAwsValue()))(
        _.moduleInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.StackResource.ReadOnly =
    zio.aws.cloudformation.model.StackResource.wrap(buildAwsValue())
}
object StackResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.StackResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.StackResource =
      zio.aws.cloudformation.model.StackResource(
        stackName.map(value => value),
        stackId.map(value => value),
        logicalResourceId,
        physicalResourceId.map(value => value),
        resourceType,
        timestamp,
        resourceStatus,
        resourceStatusReason.map(value => value),
        description.map(value => value),
        driftInformation.map(value => value.asEditable),
        moduleInfo.map(value => value.asEditable)
      )
    def stackName: Optional[StackName]
    def stackId: Optional[StackId]
    def logicalResourceId: LogicalResourceId
    def physicalResourceId: Optional[PhysicalResourceId]
    def resourceType: ResourceType
    def timestamp: Timestamp
    def resourceStatus: zio.aws.cloudformation.model.ResourceStatus
    def resourceStatusReason: Optional[ResourceStatusReason]
    def description: Optional[Description]
    def driftInformation: Optional[
      zio.aws.cloudformation.model.StackResourceDriftInformation.ReadOnly
    ]
    def moduleInfo: Optional[zio.aws.cloudformation.model.ModuleInfo.ReadOnly]
    def getStackName: ZIO[Any, AwsError, StackName] =
      AwsError.unwrapOptionField("stackName", stackName)
    def getStackId: ZIO[Any, AwsError, StackId] =
      AwsError.unwrapOptionField("stackId", stackId)
    def getLogicalResourceId: ZIO[Any, Nothing, LogicalResourceId] =
      ZIO.succeed(logicalResourceId)
    def getPhysicalResourceId: ZIO[Any, AwsError, PhysicalResourceId] =
      AwsError.unwrapOptionField("physicalResourceId", physicalResourceId)
    def getResourceType: ZIO[Any, Nothing, ResourceType] =
      ZIO.succeed(resourceType)
    def getTimestamp: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(timestamp)
    def getResourceStatus
        : ZIO[Any, Nothing, zio.aws.cloudformation.model.ResourceStatus] =
      ZIO.succeed(resourceStatus)
    def getResourceStatusReason: ZIO[Any, AwsError, ResourceStatusReason] =
      AwsError.unwrapOptionField("resourceStatusReason", resourceStatusReason)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDriftInformation: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackResourceDriftInformation.ReadOnly
    ] = AwsError.unwrapOptionField("driftInformation", driftInformation)
    def getModuleInfo
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.ModuleInfo.ReadOnly] =
      AwsError.unwrapOptionField("moduleInfo", moduleInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.StackResource
  ) extends zio.aws.cloudformation.model.StackResource.ReadOnly {
    override val stackName: Optional[StackName] = zio.aws.core.internal
      .optionalFromNullable(impl.stackName())
      .map(value => zio.aws.cloudformation.model.primitives.StackName(value))
    override val stackId: Optional[StackId] = zio.aws.core.internal
      .optionalFromNullable(impl.stackId())
      .map(value => zio.aws.cloudformation.model.primitives.StackId(value))
    override val logicalResourceId: LogicalResourceId =
      zio.aws.cloudformation.model.primitives
        .LogicalResourceId(impl.logicalResourceId())
    override val physicalResourceId: Optional[PhysicalResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.physicalResourceId())
        .map(value =>
          zio.aws.cloudformation.model.primitives.PhysicalResourceId(value)
        )
    override val resourceType: ResourceType =
      zio.aws.cloudformation.model.primitives.ResourceType(impl.resourceType())
    override val timestamp: Timestamp =
      zio.aws.cloudformation.model.primitives.Timestamp(impl.timestamp())
    override val resourceStatus: zio.aws.cloudformation.model.ResourceStatus =
      zio.aws.cloudformation.model.ResourceStatus.wrap(impl.resourceStatus())
    override val resourceStatusReason: Optional[ResourceStatusReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceStatusReason())
        .map(value =>
          zio.aws.cloudformation.model.primitives.ResourceStatusReason(value)
        )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.cloudformation.model.primitives.Description(value))
    override val driftInformation: Optional[
      zio.aws.cloudformation.model.StackResourceDriftInformation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.driftInformation())
      .map(value =>
        zio.aws.cloudformation.model.StackResourceDriftInformation.wrap(value)
      )
    override val moduleInfo
        : Optional[zio.aws.cloudformation.model.ModuleInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.moduleInfo())
        .map(value => zio.aws.cloudformation.model.ModuleInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.StackResource
  ): zio.aws.cloudformation.model.StackResource.ReadOnly = new Wrapper(impl)
}
