package zio.aws.cloudformation.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudformation.model.primitives.Timestamp
import scala.jdk.CollectionConverters._
final case class StackResourceDriftInformationSummary(
    stackResourceDriftStatus: zio.aws.cloudformation.model.StackResourceDriftStatus,
    lastCheckTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.StackResourceDriftInformationSummary = {
    import StackResourceDriftInformationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.StackResourceDriftInformationSummary
      .builder()
      .stackResourceDriftStatus(stackResourceDriftStatus.unwrap)
      .optionallyWith(
        lastCheckTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastCheckTimestamp)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.StackResourceDriftInformationSummary.ReadOnly =
    zio.aws.cloudformation.model.StackResourceDriftInformationSummary
      .wrap(buildAwsValue())
}
object StackResourceDriftInformationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.StackResourceDriftInformationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudformation.model.StackResourceDriftInformationSummary =
      zio.aws.cloudformation.model.StackResourceDriftInformationSummary(
        stackResourceDriftStatus,
        lastCheckTimestamp.map(value => value)
      )
    def stackResourceDriftStatus
        : zio.aws.cloudformation.model.StackResourceDriftStatus
    def lastCheckTimestamp: Optional[Timestamp]
    def getStackResourceDriftStatus: ZIO[
      Any,
      Nothing,
      zio.aws.cloudformation.model.StackResourceDriftStatus
    ] = ZIO.succeed(stackResourceDriftStatus)
    def getLastCheckTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastCheckTimestamp", lastCheckTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.StackResourceDriftInformationSummary
  ) extends zio.aws.cloudformation.model.StackResourceDriftInformationSummary.ReadOnly {
    override val stackResourceDriftStatus
        : zio.aws.cloudformation.model.StackResourceDriftStatus =
      zio.aws.cloudformation.model.StackResourceDriftStatus
        .wrap(impl.stackResourceDriftStatus())
    override val lastCheckTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastCheckTimestamp())
      .map(value => zio.aws.cloudformation.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.StackResourceDriftInformationSummary
  ): zio.aws.cloudformation.model.StackResourceDriftInformationSummary.ReadOnly =
    new Wrapper(impl)
}
