package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait StackSetDriftStatus {
  def unwrap
      : software.amazon.awssdk.services.cloudformation.model.StackSetDriftStatus
}
object StackSetDriftStatus {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.StackSetDriftStatus
  ): zio.aws.cloudformation.model.StackSetDriftStatus = value match {
    case software.amazon.awssdk.services.cloudformation.model.StackSetDriftStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.StackSetDriftStatus.DRIFTED =>
      val r = DRIFTED
      r
    case software.amazon.awssdk.services.cloudformation.model.StackSetDriftStatus.IN_SYNC =>
      val r = IN_SYNC
      r
    case software.amazon.awssdk.services.cloudformation.model.StackSetDriftStatus.NOT_CHECKED =>
      val r = NOT_CHECKED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.StackSetDriftStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackSetDriftStatus =
      software.amazon.awssdk.services.cloudformation.model.StackSetDriftStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object DRIFTED extends zio.aws.cloudformation.model.StackSetDriftStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackSetDriftStatus =
      software.amazon.awssdk.services.cloudformation.model.StackSetDriftStatus.DRIFTED
  }
  case object IN_SYNC extends zio.aws.cloudformation.model.StackSetDriftStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackSetDriftStatus =
      software.amazon.awssdk.services.cloudformation.model.StackSetDriftStatus.IN_SYNC
  }
  case object NOT_CHECKED
      extends zio.aws.cloudformation.model.StackSetDriftStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackSetDriftStatus =
      software.amazon.awssdk.services.cloudformation.model.StackSetDriftStatus.NOT_CHECKED
  }
}
