package zio.aws.cloudformation.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudformation.model.primitives.FailedStackInstancesCount
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class StackSetOperationStatusDetails(
    failedStackInstancesCount: Optional[FailedStackInstancesCount] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.StackSetOperationStatusDetails = {
    import StackSetOperationStatusDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.StackSetOperationStatusDetails
      .builder()
      .optionallyWith(
        failedStackInstancesCount.map(value =>
          FailedStackInstancesCount.unwrap(value): Integer
        )
      )(_.failedStackInstancesCount)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.StackSetOperationStatusDetails.ReadOnly =
    zio.aws.cloudformation.model.StackSetOperationStatusDetails
      .wrap(buildAwsValue())
}
object StackSetOperationStatusDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.StackSetOperationStatusDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudformation.model.StackSetOperationStatusDetails =
      zio.aws.cloudformation.model.StackSetOperationStatusDetails(
        failedStackInstancesCount.map(value => value)
      )
    def failedStackInstancesCount: Optional[FailedStackInstancesCount]
    def getFailedStackInstancesCount
        : ZIO[Any, AwsError, FailedStackInstancesCount] = AwsError
      .unwrapOptionField("failedStackInstancesCount", failedStackInstancesCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.StackSetOperationStatusDetails
  ) extends zio.aws.cloudformation.model.StackSetOperationStatusDetails.ReadOnly {
    override val failedStackInstancesCount
        : Optional[FailedStackInstancesCount] = zio.aws.core.internal
      .optionalFromNullable(impl.failedStackInstancesCount())
      .map(value =>
        zio.aws.cloudformation.model.primitives.FailedStackInstancesCount(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.StackSetOperationStatusDetails
  ): zio.aws.cloudformation.model.StackSetOperationStatusDetails.ReadOnly =
    new Wrapper(impl)
}
