package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait StackSetStatus {
  def unwrap
      : software.amazon.awssdk.services.cloudformation.model.StackSetStatus
}
object StackSetStatus {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.StackSetStatus
  ): zio.aws.cloudformation.model.StackSetStatus = value match {
    case software.amazon.awssdk.services.cloudformation.model.StackSetStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.StackSetStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.cloudformation.model.StackSetStatus.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.StackSetStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackSetStatus =
      software.amazon.awssdk.services.cloudformation.model.StackSetStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.cloudformation.model.StackSetStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackSetStatus =
      software.amazon.awssdk.services.cloudformation.model.StackSetStatus.ACTIVE
  }
  case object DELETED extends zio.aws.cloudformation.model.StackSetStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackSetStatus =
      software.amazon.awssdk.services.cloudformation.model.StackSetStatus.DELETED
  }
}
