package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  ClientRequestToken,
  StackSetName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StopStackSetOperationRequest(
    stackSetName: StackSetName,
    operationId: ClientRequestToken,
    callAs: Optional[zio.aws.cloudformation.model.CallAs] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.StopStackSetOperationRequest = {
    import StopStackSetOperationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.StopStackSetOperationRequest
      .builder()
      .stackSetName(StackSetName.unwrap(stackSetName): java.lang.String)
      .operationId(ClientRequestToken.unwrap(operationId): java.lang.String)
      .optionallyWith(callAs.map(value => value.unwrap))(_.callAs)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.StopStackSetOperationRequest.ReadOnly =
    zio.aws.cloudformation.model.StopStackSetOperationRequest
      .wrap(buildAwsValue())
}
object StopStackSetOperationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.StopStackSetOperationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.StopStackSetOperationRequest =
      zio.aws.cloudformation.model.StopStackSetOperationRequest(
        stackSetName,
        operationId,
        callAs.map(value => value)
      )
    def stackSetName: StackSetName
    def operationId: ClientRequestToken
    def callAs: Optional[zio.aws.cloudformation.model.CallAs]
    def getStackSetName: ZIO[Any, Nothing, StackSetName] =
      ZIO.succeed(stackSetName)
    def getOperationId: ZIO[Any, Nothing, ClientRequestToken] =
      ZIO.succeed(operationId)
    def getCallAs: ZIO[Any, AwsError, zio.aws.cloudformation.model.CallAs] =
      AwsError.unwrapOptionField("callAs", callAs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.StopStackSetOperationRequest
  ) extends zio.aws.cloudformation.model.StopStackSetOperationRequest.ReadOnly {
    override val stackSetName: StackSetName =
      zio.aws.cloudformation.model.primitives.StackSetName(impl.stackSetName())
    override val operationId: ClientRequestToken =
      zio.aws.cloudformation.model.primitives
        .ClientRequestToken(impl.operationId())
    override val callAs: Optional[zio.aws.cloudformation.model.CallAs] =
      zio.aws.core.internal
        .optionalFromNullable(impl.callAs())
        .map(value => zio.aws.cloudformation.model.CallAs.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.StopStackSetOperationRequest
  ): zio.aws.cloudformation.model.StopStackSetOperationRequest.ReadOnly =
    new Wrapper(impl)
}
