package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{TagValue, TagKey}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Tag(key: TagKey, value: TagValue) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.Tag
      .builder()
      .key(TagKey.unwrap(key): java.lang.String)
      .value(TagValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.Tag.ReadOnly =
    zio.aws.cloudformation.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.Tag
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.Tag =
      zio.aws.cloudformation.model.Tag(key, value)
    def key: TagKey
    def value: TagValue
    def getKey: ZIO[Any, Nothing, TagKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, TagValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.Tag
  ) extends zio.aws.cloudformation.model.Tag.ReadOnly {
    override val key: TagKey =
      zio.aws.cloudformation.model.primitives.TagKey(impl.key())
    override val value: TagValue =
      zio.aws.cloudformation.model.primitives.TagValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.Tag
  ): zio.aws.cloudformation.model.Tag.ReadOnly = new Wrapper(impl)
}
