package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  Description,
  NoEcho,
  ParameterValue,
  ParameterKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TemplateParameter(
    parameterKey: Optional[ParameterKey] = Optional.Absent,
    defaultValue: Optional[ParameterValue] = Optional.Absent,
    noEcho: Optional[NoEcho] = Optional.Absent,
    description: Optional[Description] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.TemplateParameter = {
    import TemplateParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.TemplateParameter
      .builder()
      .optionallyWith(
        parameterKey.map(value => ParameterKey.unwrap(value): java.lang.String)
      )(_.parameterKey)
      .optionallyWith(
        defaultValue.map(value =>
          ParameterValue.unwrap(value): java.lang.String
        )
      )(_.defaultValue)
      .optionallyWith(
        noEcho.map(value => NoEcho.unwrap(value): java.lang.Boolean)
      )(_.noEcho)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.TemplateParameter.ReadOnly =
    zio.aws.cloudformation.model.TemplateParameter.wrap(buildAwsValue())
}
object TemplateParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.TemplateParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.TemplateParameter =
      zio.aws.cloudformation.model.TemplateParameter(
        parameterKey.map(value => value),
        defaultValue.map(value => value),
        noEcho.map(value => value),
        description.map(value => value)
      )
    def parameterKey: Optional[ParameterKey]
    def defaultValue: Optional[ParameterValue]
    def noEcho: Optional[NoEcho]
    def description: Optional[Description]
    def getParameterKey: ZIO[Any, AwsError, ParameterKey] =
      AwsError.unwrapOptionField("parameterKey", parameterKey)
    def getDefaultValue: ZIO[Any, AwsError, ParameterValue] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getNoEcho: ZIO[Any, AwsError, NoEcho] =
      AwsError.unwrapOptionField("noEcho", noEcho)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.TemplateParameter
  ) extends zio.aws.cloudformation.model.TemplateParameter.ReadOnly {
    override val parameterKey: Optional[ParameterKey] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterKey())
      .map(value => zio.aws.cloudformation.model.primitives.ParameterKey(value))
    override val defaultValue: Optional[ParameterValue] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultValue())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ParameterValue(value)
      )
    override val noEcho: Optional[NoEcho] = zio.aws.core.internal
      .optionalFromNullable(impl.noEcho())
      .map(value => zio.aws.cloudformation.model.primitives.NoEcho(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.cloudformation.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.TemplateParameter
  ): zio.aws.cloudformation.model.TemplateParameter.ReadOnly = new Wrapper(impl)
}
