package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  S3Bucket,
  TypeVersionId,
  TypeName,
  TypeArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TestTypeRequest(
    arn: Optional[TypeArn] = Optional.Absent,
    `type`: Optional[zio.aws.cloudformation.model.ThirdPartyType] =
      Optional.Absent,
    typeName: Optional[TypeName] = Optional.Absent,
    versionId: Optional[TypeVersionId] = Optional.Absent,
    logDeliveryBucket: Optional[S3Bucket] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.TestTypeRequest = {
    import TestTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.TestTypeRequest
      .builder()
      .optionallyWith(
        arn.map(value => TypeArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        typeName.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.typeName)
      .optionallyWith(
        versionId.map(value => TypeVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(
        logDeliveryBucket.map(value => S3Bucket.unwrap(value): java.lang.String)
      )(_.logDeliveryBucket)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.TestTypeRequest.ReadOnly =
    zio.aws.cloudformation.model.TestTypeRequest.wrap(buildAwsValue())
}
object TestTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.TestTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.TestTypeRequest =
      zio.aws.cloudformation.model.TestTypeRequest(
        arn.map(value => value),
        `type`.map(value => value),
        typeName.map(value => value),
        versionId.map(value => value),
        logDeliveryBucket.map(value => value)
      )
    def arn: Optional[TypeArn]
    def `type`: Optional[zio.aws.cloudformation.model.ThirdPartyType]
    def typeName: Optional[TypeName]
    def versionId: Optional[TypeVersionId]
    def logDeliveryBucket: Optional[S3Bucket]
    def getArn: ZIO[Any, AwsError, TypeArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getType
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.ThirdPartyType] =
      AwsError.unwrapOptionField("type", `type`)
    def getTypeName: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getVersionId: ZIO[Any, AwsError, TypeVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getLogDeliveryBucket: ZIO[Any, AwsError, S3Bucket] =
      AwsError.unwrapOptionField("logDeliveryBucket", logDeliveryBucket)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.TestTypeRequest
  ) extends zio.aws.cloudformation.model.TestTypeRequest.ReadOnly {
    override val arn: Optional[TypeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.cloudformation.model.primitives.TypeArn(value))
    override val `type`: Optional[zio.aws.cloudformation.model.ThirdPartyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.cloudformation.model.ThirdPartyType.wrap(value))
    override val typeName: Optional[TypeName] = zio.aws.core.internal
      .optionalFromNullable(impl.typeName())
      .map(value => zio.aws.cloudformation.model.primitives.TypeName(value))
    override val versionId: Optional[TypeVersionId] = zio.aws.core.internal
      .optionalFromNullable(impl.versionId())
      .map(value =>
        zio.aws.cloudformation.model.primitives.TypeVersionId(value)
      )
    override val logDeliveryBucket: Optional[S3Bucket] = zio.aws.core.internal
      .optionalFromNullable(impl.logDeliveryBucket())
      .map(value => zio.aws.cloudformation.model.primitives.S3Bucket(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.TestTypeRequest
  ): zio.aws.cloudformation.model.TestTypeRequest.ReadOnly = new Wrapper(impl)
}
